(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    292143,       5874]
NotebookOptionsPosition[    280243,       5588]
NotebookOutlinePosition[    280630,       5604]
CellTagsIndexPosition[    280587,       5601]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Math 203 - Multivariable Calculus", "Title",
 CellChangeTimes->{{3.7132352480035334`*^9, 3.7132352566671543`*^9}, {
  3.7132353840015993`*^9, 
  3.713235386162277*^9}},ExpressionUUID->"3eff84e4-7dc3-473c-9d5f-\
5004e7960755"],

Cell[CellGroupData[{

Cell[TextData[{
 "3D Coordinates and Vectors\n",
 StyleBox["September 6, 2017", "Subchapter"]
}], "Chapter",
 CellChangeTimes->{{3.7132354004820967`*^9, 3.713235406034102*^9}, {
  3.713236857004621*^9, 3.713236868548688*^9}, {3.7134660159867067`*^9, 
  3.7134660259792247`*^9}, {3.7136367302253275`*^9, 3.7136367303689313`*^9}, {
  3.7136390134313707`*^9, 
  3.713639019486205*^9}},ExpressionUUID->"cb1b1b57-bc41-47f7-9074-\
8bf9ee7e9c6f"],

Cell["\<\
This link has a list of keyboard shortcuts for Mathematica. This can make \
entering integrals, derivatives, and other things easier! \
\>", "Text",
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 3.713465718323245*^9}, {3.7134658334571447`*^9, 
  3.713465872458172*^9}},ExpressionUUID->"76986328-9708-4592-8069-\
c192c864c775"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Keyboard Shortcuts\>\"", ",", 
   "\"\<http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html\>\""}], "]"}]], "Code",
 CellOpen->False,
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 
  3.7134657576928744`*^9}},ExpressionUUID->"e75bf68b-4f99-4eee-8d77-\
ed85dc01727e"],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->"\<\"Keyboard Shortcuts\"\>", True->
    StyleBox["\<\"Keyboard Shortcuts\"\>", "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaseStyle->{"Hyperlink"},
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html"], None},
   ButtonNote->
    "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html"],
  Annotation[#, 
   "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.713465760187833*^9, 3.7136407538491297`*^9, 
  3.71406764833868*^9},ExpressionUUID->"69e77db0-168b-4e50-8235-81048ace3a84"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1", "Section",
 CellChangeTimes->{{3.7132354217860603`*^9, 3.713235422873678*^9}, {
  3.7132357083691387`*^9, 
  3.713235713385277*^9}},ExpressionUUID->"4a24de52-2102-4d1e-9650-\
526a5cece368"],

Cell["\<\
Label the axes in the handout so that they are oriented correctly. The \
directions with tips are the positive directions.\
\>", "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 3.713236389570219*^9, 3.7135499520414915`*^9, {
   3.7136411345217924`*^9, 3.713641136729889*^9}, {3.7136412055943894`*^9, 
   3.713641247954955*^9}},ExpressionUUID->"62745f1b-6e5d-45ef-a214-\
c47b3b541279"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714069102161065*^9, 
  3.714069102906121*^9}},ExpressionUUID->"423aac1f-1e80-47d8-8ba0-\
2883ebaf50eb"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3UGO41QawPESzIIlRyhuMfKqWc4WxD4gOohNj9QgjWaVK+QGdYts+yAZ
qW4yJi9Vj3a5narY8ftix7+fZJouAl0S+cvvs1N+3/3y7x/WX93d3f3xzeEv
P/z8n+8/fvz5vz9+e/jNTx/++P23D+9//deHP9//9v7jP3/5+vDF/x+O/x2O
fxyOGgAAAAAAAAAACLSr13d39V3rqLb7a39jcPP22+rQW1XLDUp7Ptetd9f+
RmB2Hh8fe73+6dy2rtUG/b179+78F++3dWVug0EeHh7q+/v7s1+/Wx/WkdW2
Vhv0t9lsjtcZP3369PaLd+vja41tMEw6t6WG0nnudft6Wzm3wSXyfbQ3Z7jn
ua19/01/cJ50Tsvd9JnhgP5Wq9WLc1Xf+wLA+fLslo+zrpkAg7RnsXStEhhf
c3Yzw0FZ7dktH8D42rObGQ7K6WrNDAfjS7Nb6iqdy/J5Lv19+lqvzy4DveTe
3HuD8vQGcfQGcfQGcfQGcfQGcfQGcfQGcfQGcXxOGeLoDeLoDeLoDeLoDeLo
DeLoDeLoDeLoDeLoDWKkz3B57iTE0BvE0RvE0RvE0RvE0RvE0RvE0RvE0RvE
0RvESXvipN7siQPl6Q3i6A3i6A3i6A3i6A3i6A3i6A3i6A3iPDw8HHtbrVbX
/lbg5ukN4ugN4ugN4ugN4ugN4ugN4ugN4ugN4ugN4ugN4mw2m2Nv6VegLL1B
HL1BHL1BHL1BHL1BHL1BHL1BHL1BnPS5ktRb+pwJUJbeII7eII7eII7eII7e
II7eII7eII7eII7eII7eIE7a9y31lvaBA8rSG8TRG8TRG8TRG8TRG8TRG8TR
G8TRG8S5v78/9vb4+HjtbwVunt4gjt4gjt4gjt4gjt4gjt4gjt4gjt4gjt4g
TmotHUB5eoM4eoM4eoM4eoM4eoM4eoM4eoM4eoM4eoMY6TNcqbX0mS6gLL1B
nEt6S/vFpX/Pc/TgPEN7S43luU9vcJ6hveWf4dlsNmW+MbhBQ3rLz2NOvwLn
69tbOp/ldaSfT4V++vRmZoPL9OnNzAaXObc3MxtcLq8RX+soz2zuicNl3urN
zAbjea23vNY0szEn6T2d3s+r1er4Gagpea03MxtzlBrL54l8pFko93fNddqp
3sxszFVal6Wu0ns4nzO6jms02NWbmY1bkxtMfZ1qMPVXusF2b2Y2liC9z89t
cMxZsN2bmY2lSv2lHnKD+fMdY65Dm72Z2eClsWfBfC2n2bKZDU67ZBZsXzs1
s0E/fWbB5nnNOhLG0XcWTOc560oYT3Mteaq/Kd2bh7lq3mdLR+opf30K9wXh
lrRbyr21Db0v6FkL8CQ3kxrJa8pTvXUxC8J52p+NHNJblyl/RhSuoTmzte+/
XdrbqT/PLMhSdX02smRvbWZBlqI5szXlz0xe63MlZkFuTfM+W/u9eu3eupgF
mau3fnZ0ir11MQsyB/m9eWo+m0tvbWZBpuacnx2da29d2rPgaw2aBRlTc1+N
195Tt9Rbl9ygWZBS+jzv59Z762IWZEx99tVYYm9tZkGG6vu8H711MwvyliF7
Iab3Snr91J77PEVmQbKhz2jV22XMgss0dC9EvY1r6Cyowfm45BmteiuvzyyY
nwOqv2lqPqN1yPUyvV2HWXB+xthXQ2/TYRacrrH21dDbdJkFp2OsfTX0Ni9j
z4Lpv5dem17n/n23MffV0Nv8NRscMgs2fxZZdy+NvRei3m7TkOfZt7tcencl
9kLM/y+s+W/fOQ3q7rMSeyHqbblSR83PAL7V3ZLeI6X2QtTbsr22b0TXsYTu
Su5fr7flys9kah7pa/lI74l85HsTt762LL1/vd7gs9L71+sNnpx6RmuJP0Nv
LFnJma1Jbyxd174apeiNpSs9szWlazAl16swZREzGxA3s8HSRc5ssHSRMxss
mZkNYry2FyIwHtdHmILdOr0H1/Xuy39w+HpVb/fX+K7G99ZeiBDi2NVdvd61
v3zosNrWt5Cb6yNMx77eVoe2XgS3q9eH92d1Aye3c/dChCj7bfVy7Xgja0kz
G5O039ZV43x2K2vJoftqQFnPa8pjY7exljSzMWV/rym3819LDtkLEWI9ndeO
79MZryXNbMzF0724L+8NzImZjbk4ee97JsxszMfzenKmJ7dL90KESF/cg5sR
MxvEKP2MVuAzMxvEKLWvBvCSmQ1imNkgjpkNYpjZIIaZDWKY2SCOmQ1ieEYr
lNN8Zp2ZDcrJz0BOv9pXA8pqrh3NbFBO83zWPIDxpbmtq7d0rkv/zJoSxtPV
Wj6sKWE8zb2i2of72zCu/Fyt9mENCePqOrel/rQG48vX/c1qUFb7HoBZDcpp
3gOwfoSyzGoQI10nMatBjNQbAAAAAEApT/vKtfYo3m/r6vC1ao6bzcGk7ett
1dyn+Pn31bZWGxTQPJ/t1rPdRxXmYrdu/LzNTPcIh/nY1etjb85tUNrx/FZV
x3Wl2Q0KOs5sz9com38PjOx5Hfl3YO3rlcBYnq6TtGa25+uVrpsAAAAAAAAA
AACU8RdudA/H
    "], {{0, 254}, {220, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag[
   "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
    Association[
     "Exif" -> Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com"], 
      "Comments" -> 
      Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com", 
        "Creation Time" -> 
        DateObject[{2017, 9, 5, 23, 9, 42.}, "Instant", "Gregorian", -4.]]]],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{220, 254},
  PlotRange->{{0, 220}, {0, 254}}]], "Input",
 CellChangeTimes->{{3.7140676043861594`*^9, 
  3.71406761024181*^9}},ExpressionUUID->"f493bc6b-76c4-46bc-b6f3-\
5bc1844150ee"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3U2O21YWgFEj6UGGWUJlFw2OnGFPE2SuBLGCTNyAE6DRI21BO6hdaOqF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    "], {{0, 253}, {238, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag[
   "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
    Association[
     "Exif" -> Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com"], 
      "Comments" -> 
      Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com", 
        "Creation Time" -> 
        DateObject[{2017, 9, 5, 23, 9, 56.}, "Instant", "Gregorian", -4.]]]],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{238, 253},
  PlotRange->{{0, 238}, {0, 253}}]], "Input",
 CellChangeTimes->{{3.7140676043861594`*^9, 
  3.7140676130333853`*^9}},ExpressionUUID->"72ff3892-417e-4db9-938b-\
1593404b20e6"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3T2S3MYZgOGVrcDOnCqjb6FCRIdO5VJOqcxROaGrKFe5HPEKcwPeYlIe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    "], {{0, 265}, {281, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag[
   "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
    Association[
     "Exif" -> Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com"], 
      "Comments" -> 
      Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com", 
        "Creation Time" -> 
        DateObject[{2017, 9, 5, 23, 10, 50.}, "Instant", "Gregorian", -4.]]]],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{281, 265},
  PlotRange->{{0, 281}, {0, 265}}]], "Input",
 CellChangeTimes->{{3.7140676043861594`*^9, 
  3.714067622418806*^9}},ExpressionUUID->"b99f2f6d-0b02-4067-b392-\
9f6cf90d8685"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3TtuI8kdwGH5ETh07mR8C4PROHS6hvPZhUcLJ2Ng14DhaK7AG8wtlM5B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    "], {{0, 243}, {283, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag[
   "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
    Association[
     "Exif" -> Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com"], 
      "Comments" -> 
      Association[
       "Software" -> "Created with the Wolfram Language : www.wolfram.com", 
        "Creation Time" -> 
        DateObject[{2017, 9, 5, 23, 11, 47.}, "Instant", "Gregorian", -4.]]]],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{283, 243},
  PlotRange->{{0, 283}, {0, 243}}]], "Input",
 CellChangeTimes->{{3.7140676043861594`*^9, 
  3.714067629258416*^9}},ExpressionUUID->"81a70880-e02c-4e64-8cd2-\
e7b880068d5d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2", "Section",
 CellChangeTimes->{{3.7132357351372943`*^9, 
  3.7132357361843896`*^9}},ExpressionUUID->"38cc62da-8763-4d8f-ac77-\
780f62bc6421"],

Cell[TextData[{
 "Plot the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", "4"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d79cfd95-1024-4d86-9390-1cccc5a288c1"],
 " by hand. The code below plots the point in Mathematica. Run the code \
(Shift+Enter/Return or Enter on the NumPad) to see the output, and try to \
figure out what each of the commands in the code does."
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}, {3.7136422565154653`*^9, 3.713642274339729*^9}, {
   3.713642316411533*^9, 3.7136423258298893`*^9}, 3.713642664750699*^9, {
   3.713642776232035*^9, 3.7136428611922398`*^9}, {3.7136529667366405`*^9, 
   3.713652972944839*^9}},ExpressionUUID->"e4af68b7-224f-4811-a221-\
e6e794c58c0a"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140691084577246`*^9, 
  3.7140691092264585`*^9}},ExpressionUUID->"47b45be3-9520-43e1-9413-\
26b40c36e928"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2", ",", "4"}], "}"}], "]"}], ",", "Red", 
     ",", 
     RowBox[{"Arrowheads", "[", "0", "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "2", ",", "4"}], "}"}]}], "}"}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.713642468694643*^9, 3.713642630439452*^9}, {
  3.7136427208987308`*^9, 3.7136427541123724`*^9}, {3.714067690302909*^9, 
  3.7140677684688826`*^9}},ExpressionUUID->"48b38c26-5d09-4f75-993f-\
83b27af2e186"],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0, 1, 0], PointSize[Large], Point3DBox[{-1, 2, 4}], 
   {RGBColor[1, 0, 0], Arrowheads[0], 
    Arrow3DBox[{{0, 0, 0}, {-1, 0, 0}, {-1, 2, 0}, {-1, 2, 4}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{367.1310209148999, 377.6935086559906},
  PlotRange->{{-5, 5}, {-5, 5}, {-5, 5}},
  ViewPoint->{2.4510057156122182`, 1.5296614966239246`, 1.761450166136553},
  ViewVertical->{0.055634764252617014`, 0.07154371259892077, 
   0.9958846671146809}]], "Output",
 CellChangeTimes->{
  3.714067648496718*^9, {3.714067760168295*^9, 
   3.7140677696011543`*^9}},ExpressionUUID->"12f583c3-5977-4d69-8fc2-\
30ee4f5b1eca"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7132359950315733`*^9, 
  3.713235996879508*^9}},ExpressionUUID->"b558e9de-89e6-468c-a384-\
951f2a0bdef8"],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "3"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],ExpressionUUID->"aa7cbbda-ffcc-48df-b4c3-ebcb68ac5d0e"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", 
      RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  ExpressionUUID->"be672320-dae7-422e-b3b7-8baf3a4cb5f8"],
 ". Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "+", 
    OverscriptBox["b", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "4ad85476-23d4-4095-ba75-6c1f5d1967c2"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["b", "\[RightVector]"], "-", 
    OverscriptBox["a", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "123a5d08-ef6a-4e18-8885-f48f40208054"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", 
     OverscriptBox["a", "\[RightVector]"]}], "+", 
    OverscriptBox["b", "\[RightVector]"]}], TraditionalForm]],ExpressionUUID->
  "14b568bc-08c8-4437-853d-9f3e6921e764"],
 ". \n\nUse Mathematica to plot, in three different colors, the three vectors \
you computed on the same set of axes as ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["a", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "14cfff2e-375b-482c-9c4e-e80f586cb6ba"],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["b", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "8ad5bfdb-e7cf-428b-a5e1-6a3dcb8416d0"],
 ". Below is an example of plotting vectors, use it to help you. The example \
also shows one way to plot multiple items: name each of the commands \
something of your choice (for example, ",
 StyleBox["veca", "Code"],
 " and ",
 StyleBox["vacb", "Code"],
 " below), then do display all of them, use the ",
 StyleBox["Show", "Code"],
 " command."
}], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}, {3.7136428763284693`*^9, 
   3.7136428790323772`*^9}, {3.713643046249902*^9, 3.71364306299399*^9}, {
   3.7136437575308104`*^9, 3.7136438636912003`*^9}, {3.7136439018477845`*^9, 
   3.7136440080690794`*^9}, {3.713644071284747*^9, 3.7136441183571525`*^9}, 
   3.7136441975609365`*^9, {3.7136447128742466`*^9, 3.7136447522104406`*^9}, {
   3.713644914915126*^9, 3.713644921883129*^9}, {3.713645031507679*^9, 
   3.7136451268371463`*^9}, {3.7140680499885607`*^9, 
   3.7140680577251186`*^9}},ExpressionUUID->"0ba135e6-18c1-4df9-8cbc-\
613c38b69a26"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140691147134132`*^9, 
  3.714069115634225*^9}},ExpressionUUID->"f4754c4d-c4b6-4efc-a3d6-\
c2c7e95060c4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"veca", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "3"}], "}"}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecb", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecc", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecd", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Purple", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", 
           RowBox[{"-", "4"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vece", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"veca", ",", "vecb", ",", "vecc", ",", "vecd", ",", "vece"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.7136447683582687`*^9, 3.713644894699978*^9}, {
  3.713644931469398*^9, 3.7136450236724977`*^9}, {3.71406783326149*^9, 
  3.7140679259682603`*^9}},ExpressionUUID->"57580ace-2ceb-47fc-8e33-\
b906cc6d5ee7"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], ArrowBox[{{0, 0}, {-2, 3}}]}, 
   {RGBColor[1, 0, 0], ArrowBox[{{0, 0}, {4, -1}}]}, 
   {RGBColor[0, 1, 0], ArrowBox[{{0, 0}, {2, 2}}]}, 
   {RGBColor[0.5, 0, 0.5], ArrowBox[{{0, 0}, {6, -4}}]}, 
   {RGBColor[1, 0.5, 0.5], ArrowBox[{{0, 0}, {0, 5}}]}},
  Axes->True]], "Output",
 CellChangeTimes->{
  3.713644895648593*^9, 3.713644955801753*^9, {3.7136450123228626`*^9, 
   3.713645027043377*^9}, 3.713646634647018*^9, 3.714067830670059*^9, 
   3.714067928606781*^9},ExpressionUUID->"88917706-9bab-44aa-8e65-\
beddf4f65ae6"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 4", "Section",
 CellChangeTimes->{{3.713235999118843*^9, 
  3.7132360046164513`*^9}},ExpressionUUID->"d9f59dcc-177e-49cd-b037-\
24d5bddbc1a0"],

Cell[TextData[{
 "Find the vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["AB", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "aae08f12-92ef-4150-bf94-5fc53836dd0b"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "3", ",", "1"}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "38db16b3-276f-4ec9-9475-3ac5149c4bf7"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"B", "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2", ",", "3"}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "112302f7-fd9c-47a2-bef5-15ae607f1cdf"],
 ". \n\nBased on the code in problems 2 and 3, use Mathematica to plot the \
starting point of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["AB", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "a93d5d58-1e8b-47dc-9e1d-f9591280082b"],
 " in red, ending point in blue, and the vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["AB", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "db4fbb3d-b053-4485-81ce-2f33eb675526"],
 " in purple."
}], "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}, {3.713646471249406*^9, 3.713646631537095*^9}, {
   3.713651581074431*^9, 
   3.7136515819870415`*^9}},ExpressionUUID->"896178d9-5051-44e2-b0a9-\
899683fefc89"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140690913693514`*^9, 
  3.7140690926335855`*^9}},ExpressionUUID->"9b44d4a6-824b-41e4-9bc4-\
97e2024e4512"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["AB", "\[RightVector]"], "=", 
   RowBox[{
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "2"}], ",", 
      RowBox[{"2", "-", "3"}], ",", 
      RowBox[{"3", "-", "1"}]}], "\[RightAngleBracket]"}], " ", "=", " ", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "3"}], ",", 
      RowBox[{"-", "1"}], ",", "2"}], "\[RightAngleBracket]"}]}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"a3f8ca92-a6ad-4a25-96ea-da074fc4b1bc"]], \
"Text",
 CellChangeTimes->{{3.7140679502920346`*^9, 3.7140679921775613`*^9}, {
  3.7140680279404697`*^9, 
  3.71406804114764*^9}},ExpressionUUID->"c306f4ee-87db-4876-8cc0-\
6b871b529049"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vecab", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Purple", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}]}],
       "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pa", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pb", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Blue", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "2", ",", "3"}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"vecab", ",", "pa", ",", "pb"}], "]"}]}], "Input",
 CellChangeTimes->{{3.714068386128169*^9, 3.7140684389295397`*^9}, {
  3.7140689078155727`*^9, 
  3.714068987223576*^9}},ExpressionUUID->"443ab6b0-9445-4aea-ba2a-\
78a1291d5f1c"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0.5, 0, 0.5], Arrow3DBox[{{2, 3, 1}, {-1, 2, 3}}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{2, 3, 1}]}, 
   {RGBColor[0, 0, 1], PointSize[Large], Point3DBox[{-1, 2, 3}]}},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{378.3562671349895, 379.8290341020343},
  ImageSizeRaw->Automatic,
  PlotRange->{{-5, 5}, {-5, 5}, {-5, 5}},
  ViewPoint->{2.3437994366911195`, -1.7732138216882016`, 1.6769964052258175`},
  ViewVertical->{0.20304254825093082`, 0.06450886627948652, 
   0.9770426448068189}]], "Output",
 CellChangeTimes->{
  3.7140689922125916`*^9},ExpressionUUID->"70d1b73d-45fb-4a25-9f8b-\
4bc570a42f53"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7132360117278037`*^9, 3.7132360131111164`*^9}, 
   3.713236527279331*^9},ExpressionUUID->"8a849707-7d64-4ab6-84bd-\
d2ca7003e56a"],

Cell[TextData[{
 "Find an equation for the sphere with center ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"3", ",", "2", ",", "7"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c66d9bb0-61d2-4890-a016-d5c8e715380c"],
 " which passes through the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"4", ",", "3", ",", "10"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5b971f05-1589-4f33-b85e-6a9bf85bc558"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236605121499*^9}, {
  3.7136468336609907`*^9, 3.7136468362360744`*^9}, {3.7136469530118275`*^9, 
  3.7136469884451237`*^9}, {3.713647080759206*^9, 3.713647095429121*^9}, {
  3.71364721831068*^9, 
  3.7136472292706084`*^9}},ExpressionUUID->"d0a72e3d-74b0-4b4a-8ba4-\
78752449ee25"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714069074752368*^9, 3.7140690800571537`*^9}, {
  3.7140691241861563`*^9, 
  3.7140691265877295`*^9}},ExpressionUUID->"c32c33fe-6c37-4f48-a254-\
6951cc1866ee"],

Cell["\<\
The distance from the center to any point on the sphere is the radius, so \
compute that first:\
\>", "Text",
 CellChangeTimes->{{3.714069074752368*^9, 3.7140690800571537`*^9}, {
  3.7140691241861563`*^9, 
  3.7140691608651485`*^9}},ExpressionUUID->"271c9d8e-ed57-43c7-b78f-\
fbf248d14773"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["r", "2"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"[", 
      RowBox[{"d", "(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", ",", "2", ",", "7"}], ")"}], ",", 
        RowBox[{"(", 
         RowBox[{"4", ",", "3", ",", "10"}], ")"}]}], ")"}], "]"}], "2"], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "-", "3"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", "2"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"10", "-", "7"}], ")"}], "2"]}], "=", 
     RowBox[{
      RowBox[{"1", "+", "1", "+", "9"}], "=", "11"}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"3f2ae9a2-496a-4cc6-83b3-c60c65413a49"]], \
"Text",
 CellChangeTimes->{{3.714069074752368*^9, 3.7140690800571537`*^9}, {
  3.7140691241861563`*^9, 3.7140691676355534`*^9}, {3.7140698661375475`*^9, 
  3.7140699519134307`*^9}},
 TextAlignment->Center,ExpressionUUID->"966b3234-9708-47df-a47a-6597776c2d4b"],

Cell["\<\
Now that we have the radius (squared), just plug this all into the equation \
for a sphere:\
\>", "Text",
 CellChangeTimes->{{3.714069074752368*^9, 3.7140690800571537`*^9}, {
  3.7140691241861563`*^9, 3.7140691676355534`*^9}, {3.7140698661375475`*^9, 
  3.714069973527204*^9}},
 TextAlignment->Left,ExpressionUUID->"b44f1d23-fa01-4cbd-b2f8-52c6130e4f7e"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "7"}], ")"}], "2"]}], "=", "11"}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"9b6f6abd-2f49-42e4-a6d6-c6bf4dfd69ee"]], \
"Text",
 CellChangeTimes->{{3.714069074752368*^9, 3.7140690800571537`*^9}, {
  3.7140691241861563`*^9, 3.7140691676355534`*^9}, {3.7140698661375475`*^9, 
  3.71406999414375*^9}},
 TextAlignment->Center,ExpressionUUID->"ea703166-a855-4ea2-a02c-a677c4c20208"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 6", "Section",
 CellChangeTimes->{{3.71323602223969*^9, 
  3.713236023623618*^9}},ExpressionUUID->"9b176684-111d-4f29-bacc-\
264336849fa2"],

Cell[TextData[{
 "Does ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"], "+", 
     RowBox[{"2", "x"}], "-", 
     RowBox[{"6", "z"}]}], "=", 
    RowBox[{"-", "11"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "97ccec8d-4b86-4fa9-9052-fcf58f812dc8"],
 " represent the equation of a sphere? If yes, give the center and radius of \
the sphere. If no, explain why not."
}], "Text",
 CellChangeTimes->{{3.71323665278123*^9, 3.713236767453306*^9}, {
  3.7134677776202555`*^9, 3.713467782061041*^9}, {3.713647234575392*^9, 
  3.7136473046399937`*^9}},ExpressionUUID->"39594a9e-f325-4236-abf3-\
e2f0761de3dd"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714070002885285*^9, 
  3.714070005049602*^9}},ExpressionUUID->"7ce36950-6f94-4fe7-bd0e-\
7029a7a5cce9"],

Cell[TextData[{
 "To check if this is a sphere, just try to fit it to the equation of a \
sphere. This means we need to complete the square on each of the variables ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "572b0153-896e-476e-a20a-0276262c5a89"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9cf31694-7aa1-4e15-9033-3df107b803de"],
 ", and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2f418d03-956c-4388-a0f1-963ca96037ba"],
 ":"
}], "Text",
 CellChangeTimes->{{3.714070002885285*^9, 
  3.714070064869235*^9}},ExpressionUUID->"7fc82de7-8379-4d3e-9b6a-\
d5654dc9f5fe"],

Cell["", "Text",
 CellChangeTimes->{{3.714070002885285*^9, 3.714070049830761*^9}},
 TextAlignment->Center,ExpressionUUID->"6594702e-f0a8-4d26-a262-2963f54ed661"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"], "+", 
          RowBox[{"2", "x"}], "-", 
          RowBox[{"6", "z"}]}], "=", 
         RowBox[{"-", "11"}]}]},
       {
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            RowBox[{"2", "x"}]}], ")"}], "+", 
          SuperscriptBox["y", "2"], "+", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["z", "2"], "-", 
            RowBox[{"6", "z"}]}], ")"}]}], "=", 
         RowBox[{"-", "11"}]}]},
       {
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            RowBox[{"2", "x"}], 
            StyleBox["+",
             FontColor->RGBColor[0, 0.67, 0]], 
            StyleBox["1",
             FontColor->RGBColor[0, 0.67, 0]]}], ")"}], "+", 
          SuperscriptBox["y", "2"], "+", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["z", "2"], "-", 
            RowBox[{"6", "z"}], 
            StyleBox["+",
             FontColor->RGBColor[0.5, 0, 0.5]], 
            StyleBox["9",
             FontColor->RGBColor[0.5, 0, 0.5]]}], ")"}]}], "=", 
         RowBox[{
          RowBox[{"-", "11"}], 
          StyleBox["+",
           FontColor->RGBColor[0, 0.67, 0]], 
          StyleBox["1",
           FontColor->RGBColor[0, 0.67, 0]], 
          StyleBox["+",
           FontColor->RGBColor[0.5, 0, 0.5]], 
          StyleBox["9",
           FontColor->RGBColor[0.5, 0, 0.5]]}]}]},
       {
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "+", "1"}], ")"}], "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"z", "-", "3"}], ")"}], "2"]}], "=", 
         RowBox[{"-", "1"}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"8ac0115d-8a0d-4b41-8b23-a9a2c46bd03d"]], \
"Text",
 CellChangeTimes->{{3.714070204177747*^9, 3.7140702480515194`*^9}, {
  3.71407030955828*^9, 3.7140703377671385`*^9}, {3.7140703754226103`*^9, 
  3.714070391011713*^9}},ExpressionUUID->"cfbbc5f6-a610-49a5-81fe-\
6189c73958b9"],

Cell[TextData[{
 "This equation would seem to imply that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["r", "2"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "01cf0bd3-8be8-49ed-85c0-88c5503c973f"],
 " should be negative, which is impossible. So this is not an equation of a \
sphere."
}], "Text",
 CellChangeTimes->{{3.714070395618658*^9, 
  3.7140704279870777`*^9}},ExpressionUUID->"33a46428-5e62-431c-a746-\
41f94d3b9173"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 7", "Section",
 CellChangeTimes->{{3.713236026463976*^9, 
  3.7132360275922284`*^9}},ExpressionUUID->"213b8a14-dd5d-4c8b-839d-\
d0746db10921"],

Cell[TextData[{
 "Describe and sketch the region in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]],
  ExpressionUUID->"bd1b94b5-acc3-41cd-95c1-a0826b5296f5"],
 " determined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "4"}], TraditionalForm]],
  ExpressionUUID->"285aac3b-1057-4718-b579-1efe1c7a27c2"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["z", "2"]}], "\[LessEqual]", "9"}], TraditionalForm]],
  ExpressionUUID->"492e9738-a095-4082-a2c6-b018304b1bf1"],
 ". \n\nGraph the boundaries of this region on the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "4"}], "]"}], "\[Cross]", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "4"}], "]"}], "\[Cross]", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "4"}], "]"}]}], TraditionalForm]],
  ExpressionUUID->"4d57592b-da7f-4dfe-97da-6e83c61ca8e2"],
 " using Mathematica. You will need the ",
 StyleBox["ContourPlot3D", "Code"],
 " command to plot these. When you type your contours (equations to graph), \
make sure you type a double equal sign in the equation (otherwise it thinks \
you are defining a variable).\n\nI recommend adding ",
 StyleBox["AxesOrigin\[Rule]{0,0,0},AxesLabel\[Rule]{x,y,z},Boxed\[Rule]\
False", "Code"],
 " before you close the ContourPlot3D command. This places the origin in the \
proper place (otherwise the axes are placed around the edge of the graph), \
labels the axes, and removes a framed boundary of the graph. The three \
commands are mostly aesthetic here, but aesthetics are important!"
}], "Text",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 3.713468976067685*^9}, 
   3.7136476819867496`*^9, {3.7136480727489834`*^9, 3.7136480756513257`*^9}, {
   3.7136482157401752`*^9, 3.713648255587457*^9}, {3.7136482910770264`*^9, 
   3.713648335588113*^9}, {3.7136486123195176`*^9, 3.7136487071242495`*^9}, {
   3.7136516126116576`*^9, 3.7136516678198004`*^9}, {3.7136518137644463`*^9, 
   3.713652113941457*^9}},ExpressionUUID->"140bdf55-ab75-4f74-9e26-\
7f21c5377a32"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.714070480345557*^9, 
  3.714070482614976*^9}},ExpressionUUID->"3e299192-f786-4259-b6fd-\
92f85ff569f8"],

Cell[TextData[{
 "This region is the solid that is inside the cylinder of radius ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a260ac03-5dfb-4511-8bfe-1b7b2b3431a3"],
 " centered on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ea7ac706-212a-4614-9346-84822b8499fb"],
 "-axis and outside the sphere of radius ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "972ea6a7-2871-476a-8dd7-02cb79880d2f"],
 " centered at the origin. The graphs below show the boundaries of this \
region."
}], "Text",
 CellChangeTimes->{{3.714070480345557*^9, 3.7140705421697445`*^9}, {
  3.714070746810526*^9, 
  3.7140707599059696`*^9}},ExpressionUUID->"c3769bfe-97e0-4039-a440-\
69f3f4b60280"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "4"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   StyleBox[
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "Code"], 
   StyleBox[",", "Code"], 
   StyleBox[
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "Code"], 
   StyleBox[",", "Code"], 
   StyleBox[
    RowBox[{"Boxed", "\[Rule]", "False"}], "Code"]}], "]"}]], "Input",
 CellChangeTimes->{{3.7140706500889397`*^9, 
  3.7140707287606363`*^9}},ExpressionUUID->"474697e6-5157-4ac8-96ae-\
139866b59a77"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nXucj9X2x92JFJ2QbhKR+62QHN/pKuWUSqUUUkS6KKROUUnKJbdCF5VQ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   "], {{
     {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
       GrayLevel[1], 3], 
      StyleBox[GraphicsGroup3DBox[
        TagBox[{Polygon3DBox[CompressedData["
1:eJwt1XuQjmUYx/F7edcWsVERcuq0OdTYsBaFHctuUmNXI5Q1zCCHWWd/KDuY
nIYawpRVU7tYh5laYzLVaoupNDVrS6sSqqlpRhg6IVLqc8/TH9d8f9fvvu7r
PjzP875dJs0qLm0UQtgmGovFqRB2Yhn+eUMIq+nLmH1jCEuahjAd9xs7xn8X
94gv6RrsaWyRmmlYgFt5lTgfX1UzD/Plc3EFfqXvaP4RvCRW0a+0CGGwsRI1
T+N4XMKfgC3ETfT1uCgjhI9wu5pD+AP/Y/wxM4Qq3m8tQ9gs3x97xvXF+3Ql
3m5/RWoKcKf8c/4ufM0e2tEVuF6wwhYsVFsl2Yyb5aaFcryLGM17BPtiazWP
Yzm+qWYF7lPXGe9Wsx3rQtJri3OW0t8ZvyCW0S/zcp1rAd0Pr/KX0n/E5yD/
wrw39G/Ai/yj+LVzzuR10/9nZ99NX+AdE6V0D/4ycw+r3SU/h43TQjiPZ8RV
fc7ip+I0XZdKzt7YnKHmbsB/4h1iOmYJ00O9unMh6bvW2In4LsS92UM5nrf+
cTGHvk+f/ObWUz8cG/iT+Vn8meZtDMk7UeX8z+EBPWbgOv4snKj/XnoqDjFv
Nm857lW3FL/Xbzl9a3x37f2ofDq/q/7T4nnMLcWVajrGZ6Ommi5T863aherG
632dvV0z3twB0xz2jLEp/NbGuxmr1+dO3GSfeXStPjnyhWrK1PTGJ/ldsY18
Bi7GtmIFvRLnYYOa2Zht7nz8xTpH9XqCfww/FMPpQ5gfz08Pjc9IPiLePY7V
a5L9b3SOh4yN4+dhfzGKzsVcNfvwfuus+f87HBv3QS+gh2JbeT/17XC2fBj/
3ozk2y/Ek/Y2jz+OPwifEoPpLGMH6N/pEfiN+qn6tLBme/F87GFuT+MD+ffE
d9e9tXK3nY3XmdPIHVeq28GvCck9H4zfbvw++N2xL78HrpGfjb9LOED+KP0g
DpE/SxdgS3kHulUq6ZFmrdOpZD9X+A+7h0xREfeJfcTJ+O1b/3WRUv9YfL7q
P7GP9PheyP9WMwYLxCW6EPsbq1azCm+xxh0h+f5/8jx2xntx9oHqTvEH4Vb9
d8XfLrqj+IDujtv5y8yrNe82+Vv89jhRjz78B+IzVtOb39RaE+TZ/AE4Sl6C
68ztQv/rB/wFz6FGZKlZnZk8z8nxfuJvp5qR7mkmvqhnDm9DZvIeHlfTu3my
ZhHdNz5j+ZH47PBmc0aZOwdT8vL4f4EbrJXOH8Y/TOfyD+I15z9sb/n81WKd
mg5Yb70d8b7MnSLP42fGcd475q6Pv/vxf4NehNV69aD3YKU9P8N7T480bMJv
hDuMdaJ341nrbrJujp671S2gT/CuiBp6IL9YdLBuM8zltdFjDP6lZj8O4m8U
FRnJu9os/gbE+8fP9NymvpP9Fxlrk5E8lxLRKyN5/0can6u+GI+rr9DzV72v
ilo6T80pei3dK34r4iVzO+JF9W/zLxsvsUYz7+TY+D4Yy1FzyhmbxN8o/VP4
H2TP+x8=
           "]], Polygon3DBox[CompressedData["
1:eJxN3AeUNUXxNvABLiwsd/feRRRRgggKSFSRKJJzDpKz5GAWQYJkJOecgyJR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           "]], Polygon3DBox[CompressedData["
1:eJwtlgtQVVUUhjd68OjpAufmgKVmooKQPXwlYJovEtRRQVPEFBNFoxRQNCWf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           "]], 
          Polygon3DBox[{{4588, 2712, 4045, 3752, 1185, 4044}, {3993, 1076, 
           3269, 3992, 2659, 4562}, {3743, 1133, 4020, 4205, 2691, 4021}, {
           3731, 1044, 3969, 4558, 2644, 4132}, {4006, 1110, 3304, 4143, 2676,
            4199}, {4162, 2754, 4241, 4089, 1256, 3406}, {4229, 2732, 4073, 
           3754, 1224, 4074}, {4146, 2698, 4580, 4022, 1144, 3335}}]},
         Annotation[#, "Charting`Private`Tag$41523#1"]& ]],
       Lighting->{{"Ambient", 
          RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
         "Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{0, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 0, 2}]}}]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
       GrayLevel[1], 3], 
      StyleBox[GraphicsGroup3DBox[
        TagBox[Polygon3DBox[CompressedData["
1:eJw13XWcbWX1BvA7M8zcmTt3zgQg0l2CklJKqIB0SXdLN1JKSUkjEgoIirQ0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          "]],
         Annotation[#, "Charting`Private`Tag$41523#2"]& ]],
       Lighting->{{"Ambient", 
          RGBColor[
          0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
         "Directional", 
          RGBColor[
          0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
          ImageScaled[{0, 2, 2}]}, {"Directional", 
          RGBColor[
          0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
          ImageScaled[{2, 2, 2}]}, {"Directional", 
          RGBColor[
          0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
          ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0U0rhHEYhfEbsRu2JI1BNMxIsfAWZiFSLLAnRFJjQYkpsWMvX0BKUrLz
CUh5qSELWShfgWLnN1mcrnOdnv/M85JaWJ/Ol0XEqiwmItLkBIt4ii/4WR2x
Xxlxwd/4u3zYdm1H+rG88jw/089lXi/a5krn+BJe4jJeYaEqYkdmKyL2cAo3
cawmYgMn+YxslTa/06G3yDjv4616VgZcP2Hrt6V4LzbhMN6XR9RinTzo9fiI
jc6UO9PAn/idJG1hu9WfpZN38R/9SzJ6xpbFb96Lv9iNPaV79ExpzzaKbTiC
TXjtP5oxxwclqa95j0P6tuT4IS/oW3Lj+mHbga2Hr2B76f0l/r/PH26kMQs=

       "]], Line3DBox[CompressedData["
1:eJwl0UsrRHEcxvEfEzvjLZg3IPE+LOSSe1FkY8QsWNhZuESNS7HFinLJlpKF
MLH2AjQZ10wxC5TPyeLp+3yfOf9zOmcyQ9m28aqIGJN8TcQnWcMK7tdG7Ml2
KuIAd/AIe+sjDnGXr8qWnk1HrOtTssi7eU6fkFbXz9u6bFk+iDM4gP0yrefx
B1fwBkedKTgzyy/5lYzYrm3n+oXkeJk/6EV50ydt71jmr/iBJXySzmr39m7t
eIUdeIspZ+5wmPdIQb+vi+jT5+SZv/BlfUHSri/ZirbF5HdcwkdswFM8k0zy
PGzBivc4cabAG3mTfNmObc16KrkP3+Tfvv2vbOil5LviV9X///MHHvhGKA==

       "]]}, {}, {}, {}, {}, {}, 
     {GrayLevel[0.2], 
      Line3DBox[{1315, 1313, 2788, 1317, 2799, 1329, 2801, 1290, 2770, 1288, 
       2768, 1286, 2782, 1305, 2780, 1303, 2883, 1438, 2885, 1440, 2901, 2902,
        1450, 2904, 1416, 2868, 1414, 2866, 1412, 2876, 1431, 1429}], 
      Line3DBox[{1319, 1318, 2791, 1309, 2786, 1308, 2785, 1297, 2774, 1296, 
       2775, 1298, 2778, 1300, 2776, 1299, 2886, 1441, 2890, 1435, 2879, 2880,
        1434, 2878, 1423, 2872, 1422, 2873, 1424, 2874, 1426, 1425}], 
      Line3DBox[{1321, 1320, 2789, 1322, 2792, 1324, 2790, 1323, 2795, 1326, 
       2794, 1295, 2773, 1294, 2777, 1301, 2887, 1442, 2888, 1443, 2891, 2892,
        1445, 2889, 1444, 2895, 1447, 2894, 1421, 2871, 1420, 1427}], 
      Line3DBox[{1375, 1373, 2836, 1377, 2847, 1391, 2849, 1352, 2818, 1350, 
       2816, 1348, 2831, 1368, 2828, 1366, 2937, 1492, 2939, 1494, 2955, 2956,
        1505, 2959, 1471, 2923, 1469, 2921, 1467, 2931, 1487, 1485}], 
      Line3DBox[{1380, 1379, 2840, 1372, 2835, 1371, 2834, 1359, 2822, 1358, 
       2823, 1360, 2826, 1362, 2824, 1361, 2941, 1496, 2945, 1491, 2935, 2936,
        1490, 2934, 1478, 2927, 1477, 2928, 1479, 2929, 1481, 1480}], 
      Line3DBox[{1382, 1381, 2838, 1383, 2841, 1385, 2839, 1384, 2845, 1388, 
       2843, 1357, 2821, 1356, 2825, 1363, 2942, 1497, 2943, 1498, 2946, 2947,
        1500, 2944, 1499, 2952, 1503, 2950, 1476, 2926, 1475, 1482}], 
      Line3DBox[{1390, 1389, 2846, 1387, 2842, 1386, 2844, 1355, 2820, 1354, 
       2830, 1370, 2833, 1365, 2827, 1364, 2954, 1504, 2953, 1502, 2948, 2949,
        1501, 2951, 1474, 2925, 1473, 2930, 1489, 2933, 1484, 1483}], 
      Line3DBox[{1406, 1405, 2860, 1404, 2859, 1403, 2863, 1396, 2852, 1395, 
       2854, 1398, 2857, 1402, 2856, 1401, 2969, 1519, 2970, 1518, 2967, 2968,
        1517, 2975, 1510, 2962, 1509, 2964, 1512, 2965, 1516, 1515}], 
      Line3DBox[{1428, 1430, 2875, 1411, 2865, 1413, 2867, 1415, 2903, 1449, 
       2900, 2899, 1439, 2884, 1437, 2882, 1302, 2779, 1304, 2781, 1285, 2767,
        1287, 2769, 1289, 2800, 1328, 2798, 1316, 2787, 1312, 1314}], 
      Line3DBox[{1432, 1433, 2877, 1417, 2869, 1418, 2870, 1419, 2893, 1446, 
       2898, 2897, 1448, 2896, 1436, 2881, 1306, 2783, 1307, 2784, 1291, 2771,
        1292, 2772, 1293, 2793, 1325, 2797, 1327, 2796, 1310, 1311}], 
      Line3DBox[{1457, 1458, 2909, 1455, 2907, 1453, 2906, 1454, 2917, 1461, 
       2912, 2911, 1462, 2915, 1464, 2914, 1336, 2806, 1337, 2807, 1334, 2804,
        1332, 2803, 1333, 2813, 1340, 2810, 1341, 2811, 1344, 1345}], 
      Line3DBox[{1486, 1488, 2932, 1468, 2922, 1470, 2924, 1472, 2960, 1506, 
       2958, 2957, 1495, 2940, 1493, 2938, 1367, 2829, 1369, 2832, 1349, 2817,
        1351, 2819, 1353, 2850, 1392, 2848, 1378, 2837, 1374, 1376}], 
      Line3DBox[{1536, 1535, 2986, 1537, 2987, 1539, 2988, 1526, 2978, 1525, 
       2983, 1532, 2982, 1531, 2981, 1530, 3096, 1679, 3097, 1680, 3099, 3100,
        1681, 3101, 1670, 3090, 1669, 3093, 1676, 3092, 1675, 1674}], 
      Line3DBox[{1581, 1579, 3022, 1583, 3030, 1594, 3032, 1546, 2994, 1544, 
       2992, 1542, 3014, 1572, 3012, 1570, 3133, 1721, 3135, 1723, 3149, 3150,
        1730, 3152, 1688, 3108, 1686, 3106, 1684, 3124, 1714, 1712}], 
      Line3DBox[{1584, 1576, 3019, 1575, 3020, 1577, 3028, 1551, 2997, 1550, 
       3002, 1549, 2996, 1548, 2995, 1547, 3136, 1718, 3129, 1717, 3130, 3131,
        1719, 3145, 1693, 3110, 1692, 3117, 1691, 3109, 1690, 1689}], 
      Line3DBox[{1588, 1586, 3026, 1555, 2999, 1553, 3001, 1557, 3016, 1563, 
       3005, 1561, 3010, 1567, 3007, 1565, 3138, 1725, 3142, 1697, 3113, 3114,
        1695, 3116, 1699, 3126, 1705, 3120, 1703, 3122, 1709, 1707}], 
      Line3DBox[{1592, 1590, 3023, 1589, 3027, 1591, 3024, 1574, 3017, 1573, 
       3018, 1559, 3003, 1558, 3008, 1568, 3146, 1727, 3139, 1726, 3143, 3144,
        1728, 3140, 1716, 3127, 1715, 3128, 1701, 3118, 1700, 1710}], 
      Line3DBox[{1651, 1649, 3076, 1653, 3085, 1665, 3087, 1617, 3049, 1615, 
       3047, 1613, 3069, 1642, 3066, 1640, 3194, 1783, 3196, 1785, 3211, 3212,
        1793, 3215, 1751, 3171, 1749, 3169, 1747, 3187, 1776, 1774}], 
      Line3DBox[{1658, 1656, 3080, 1623, 3052, 1621, 3054, 1625, 3071, 1633, 
       3059, 1631, 3064, 1637, 3061, 1635, 3199, 1787, 3203, 1757, 3174, 3175,
        1755, 3178, 1759, 3189, 1767, 3183, 1765, 3185, 1771, 1769}], 
      Line3DBox[{1664, 1661, 3078, 1660, 3082, 1662, 3079, 1646, 3073, 1645, 
       3074, 1630, 3058, 1629, 3063, 1639, 3210, 1790, 3201, 1789, 3205, 3206,
        1791, 3202, 1780, 3191, 1779, 3192, 1764, 3182, 1763, 1773}], 
      Line3DBox[{1706, 1708, 3121, 1702, 3119, 1704, 3125, 1698, 3115, 1694, 
       3112, 3111, 1696, 3141, 1724, 3137, 1564, 3006, 1566, 3009, 1560, 3004,
        1562, 3015, 1556, 3000, 1552, 2998, 1554, 3025, 1585, 1587}], 
      Line3DBox[{1711, 1713, 3123, 1683, 3105, 1685, 3107, 1687, 3151, 1729, 
       3148, 3147, 1722, 3134, 1720, 3132, 1569, 3011, 1571, 3013, 1541, 2991,
        1543, 2993, 1545, 3031, 1593, 3029, 1582, 3021, 1578, 1580}], 
      Line3DBox[{1737, 1738, 3157, 1740, 3158, 1733, 3154, 1734, 3166, 1745, 
       3164, 3163, 1744, 3161, 1743, 3160, 1601, 3037, 1602, 3039, 1604, 3040,
        1597, 3034, 1598, 3045, 1611, 3043, 1609, 3042, 1607, 1608}], 
      Line3DBox[{1770, 1772, 3186, 1766, 3184, 1768, 3190, 1760, 3179, 1756, 
       3177, 3176, 1758, 3204, 1788, 3200, 1636, 3062, 1638, 3065, 1632, 3060,
        1634, 3072, 1626, 3055, 1622, 3053, 1624, 3081, 1657, 1659}], 
      Line3DBox[{1775, 1777, 3188, 1748, 3170, 1750, 3172, 1752, 3216, 1794, 
       3214, 3213, 1786, 3197, 1784, 3195, 1641, 3067, 1643, 3070, 1614, 3048,
        1616, 3050, 1618, 3088, 1666, 3086, 1654, 3077, 1650, 1652}], 
      Line3DBox[{1778, 1753, 3173, 1754, 3180, 1761, 3181, 1762, 3207, 1792, 
       3209, 3208, 1781, 3193, 1782, 3198, 1644, 3068, 1619, 3051, 1620, 3056,
        1627, 3057, 1628, 3083, 1663, 3084, 1647, 3075, 1648, 1655}], 
      Line3DBox[{1343, 1342, 2812, 1346, 2814, 1347, 2815, 1335, 2805, 1331, 
       2802, 1330, 2809, 1339, 2808, 1338, 2913, 1463, 2916, 1465, 2918, 2919,
        1466, 2920, 1456, 2908, 1452, 2905, 1451, 2910, 1460, 1459}], 
      Line3DBox[{1409, 1408, 2861, 1407, 2862, 1410, 2864, 1397, 2853, 1394, 
       2851, 1393, 2858, 1400, 2855, 1399, 2972, 1521, 2971, 1520, 2973, 2974,
        1522, 2976, 1511, 2963, 1508, 2961, 1507, 2966, 1514, 1513}], 
      Line3DBox[{1538, 1534, 2985, 1533, 2990, 1540, 2989, 1524, 2977, 1523, 
       2979, 1527, 2984, 1529, 2980, 1528, 3098, 1678, 3095, 1677, 3103, 3104,
        1682, 3102, 1668, 3089, 1667, 3091, 1671, 3094, 1673, 1672}], 
      Line3DBox[{1610, 1606, 3041, 1605, 3046, 1612, 3044, 1596, 3033, 1595, 
       3035, 1599, 3036, 1600, 3038, 1603, 3162, 1742, 3159, 1741, 3167, 3168,
        1746, 3165, 1732, 3153, 1731, 3155, 1735, 3156, 1736, 1739}], 
      Line3DBox[{2637, 1024, 2690, 1099, 2666, 4137, 1091, 2663, 1090, 3995, 
       2662, 1086, 3994, 1087, 4001, 1102, 4000, 3999, 1103, 4008, 1115, 4007,
        1116, 4013, 1126, 2684, 4014, 1127, 2685, 1125, 4144, 2682, 1124, 
       2681, 1058, 2650, 1056, 4134, 2649, 1057, 1066, 3978, 2653, 1065, 3979,
        1069, 3982, 1071, 3980, 1070, 3985, 3986, 1036, 3964, 1035, 3967, 
       1039, 2642, 3968, 1040, 1027, 2638, 4129, 1023, 2637}], 
      Line3DBox[{1025, 1026, 4131, 4130, 2641, 1038, 1033, 3963, 1034, 3966, 
       3965, 1037, 3976, 1059, 3981, 1067, 1068, 2654, 3984, 3983, 1072, 1064,
        2652, 1061, 2651, 1060, 2679, 1122, 2680, 1123, 2683, 1118, 4009, 
       4010, 2677, 1117, 1119, 4012, 1120, 4011, 1101, 3996, 3997, 1100, 3998,
        1097, 1089, 2661, 4135, 4136, 1088, 2664, 1096, 2665, 1098, 2667, 
       1032, 2640, 1031, 2639, 1025}], 
      Line3DBox[{3961, 1029, 3991, 1082, 1080, 2658, 3988, 1062, 3977, 1063, 
       2659, 3992, 1083, 1085, 2660, 1084, 2678, 1121, 2693, 1136, 4020, 1133,
        2689, 4018, 1130, 4015, 2686, 1129, 1134, 4019, 1105, 4002, 4003, 
       1104, 1106, 2668, 4138, 1109, 4140, 2670, 1110, 4006, 1114, 2675, 1113,
        2674, 1049, 2645, 1041, 1042, 4132, 2644, 1048, 3973, 1052, 4133, 
       2646, 1030, 1028, 3962, 3961}], 
      Line3DBox[{2643, 1044, 3969, 1047, 2648, 1053, 3972, 1050, 3971, 3970, 
       1051, 3990, 1081, 3989, 1074, 2655, 1073, 3993, 1076, 2656, 1075, 2692,
        1137, 2691, 4021, 1135, 1131, 2687, 4016, 1128, 4017, 1108, 4004, 
       4005, 1107, 4139, 2669, 1093, 1092, 4143, 2676, 1111, 2671, 1043, 
       2643}], Line3DBox[{1045, 1046, 2647, 1054, 3975, 3974, 1055, 3987, 
       1078, 2657, 1077, 1079, 2694, 1138, 1132, 2688, 4145, 1112, 4141, 4142,
        2673, 1095, 1094, 2672, 1045}], 
      Line3DBox[{1139, 1140, 2699, 1154, 4029, 4028, 1156, 4046, 1191, 2713, 
       1190, 1189, 2753, 1265, 1257, 2747, 4159, 1231, 4071, 4072, 2730, 1230,
        1229, 2729, 1139}], 
      Line3DBox[{2695, 1142, 4027, 1151, 4024, 4023, 1152, 4049, 1195, 4050, 
       1196, 2722, 1187, 4044, 1185, 2711, 1184, 2751, 1264, 2754, 4162, 1258,
        1259, 2748, 4160, 1260, 4088, 1219, 4064, 4065, 1218, 4067, 2727, 
       1226, 1228, 4073, 2732, 1232, 2733, 1143, 2696, 1144, 4022, 1141, 
       2695}], Line3DBox[{2697, 1146, 1147, 4146, 2698, 1148, 4030, 1155, 
       4147, 2700, 1150, 1149, 4026, 4025, 1153, 4048, 1193, 1192, 2714, 4051,
        1194, 4047, 1188, 2712, 4045, 1186, 1183, 2710, 1182, 2750, 1263, 
       2752, 1266, 4089, 1256, 2746, 4158, 1255, 4161, 2749, 1262, 1261, 4099,
        1227, 4069, 4070, 1223, 1222, 2728, 4068, 1225, 4066, 2726, 1224, 
       4074, 1221, 2725, 1220, 2731, 1145, 2697}], 
      Line3DBox[{2701, 1158, 1178, 4151, 4150, 2709, 1181, 1177, 4039, 1175, 
       4038, 4037, 1176, 4060, 1213, 4059, 1212, 1211, 2721, 4058, 4057, 1210,
        1200, 2715, 1199, 2720, 1209, 2760, 1279, 2759, 1280, 2764, 1282, 
       4100, 4101, 2761, 1281, 1278, 4095, 1277, 4098, 1254, 4086, 4087, 1251,
        4080, 1236, 1235, 2735, 4154, 4155, 1234, 2734, 1233, 2741, 1248, 
       2743, 1170, 2706, 1157, 2701}], 
      Line3DBox[{4031, 1161, 1163, 2707, 4032, 1165, 2704, 1167, 2742, 1249, 
       2744, 4085, 1246, 2739, 1244, 4156, 2737, 1241, 4077, 1237, 4075, 1239,
        4082, 4081, 1252, 4093, 1275, 4096, 1269, 4090, 1267, 2757, 4092, 
       1273, 2755, 1271, 4164, 2765, 1283, 2762, 1203, 2716, 1205, 4152, 2718,
        1207, 1216, 4153, 2723, 1214, 4061, 1201, 4054, 1197, 4052, 1173, 
       4033, 4034, 1171, 4042, 1179, 4040, 1159, 2702, 4031}], 
      Line3DBox[{2703, 1160, 4041, 1180, 4043, 1172, 4036, 4035, 1174, 4053, 
       1198, 4055, 1202, 4062, 1215, 2724, 4063, 1217, 1208, 2719, 4056, 1206,
        2717, 1204, 2763, 1284, 2766, 4102, 1272, 2756, 1274, 4163, 2758, 
       1268, 4091, 1270, 4097, 1276, 4094, 1253, 4083, 4084, 1240, 4076, 1238,
        4078, 1242, 2738, 4079, 1245, 2740, 1247, 4157, 2745, 1250, 1243, 
       2736, 1169, 1168, 2705, 1166, 4149, 2708, 1164, 1162, 4148, 2703}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{4165, 2637, 1796, 2705, 2704, 4586, 1894, 2706, 1884, 2697, 
       1883, 4579, 2696, 1879, 4210, 1880, 4578, 1881, 2699, 4213, 4212, 1888,
        4217, 2713, 2632, 4216, 1900, 4220, 1898, 2711, 4215, 1897, 2710, 
       1896, 2720, 1908, 4591, 2716, 2717, 1816, 2650, 4177, 1815, 2651, 1819,
        2660, 1827, 4561, 2656, 1824, 4180, 1825, 4183, 2620, 2657, 4181, 
       1812, 4559, 4560, 2647, 2615, 4169, 1808, 4170, 1806, 2643, 4168, 1807,
        2645, 1801, 2640, 1795, 4165}], 
      Line3DBox[{4166, 1798, 2639, 1799, 2638, 1800, 2708, 2707, 1892, 2701, 
       1891, 4214, 1885, 2698, 4580, 2629, 2695, 1882, 4211, 1887, 4585, 4584,
        1890, 4219, 1901, 4218, 1902, 2722, 2631, 4588, 2712, 1899, 4221, 
       1906, 2715, 1905, 2718, 2719, 1814, 2649, 1813, 2652, 1820, 4178, 1821,
        2659, 4562, 2619, 2655, 1826, 4182, 1828, 4184, 2618, 4175, 4176, 
       1811, 4174, 1810, 2648, 2616, 4558, 2644, 1797, 4166}], 
      Line3DBox[{1802, 1803, 2641, 4167, 1804, 2642, 1805, 2703, 2702, 1893, 
       4587, 2709, 1895, 1889, 4583, 2700, 2630, 4582, 4581, 1886, 4589, 1903,
        2714, 4590, 1904, 1907, 2721, 4592, 1909, 2723, 2724, 1823, 2653, 
       1822, 4179, 2654, 1818, 1817, 4185, 2658, 1829, 4186, 2617, 4171, 4172,
        1809, 2646, 4173, 1802}], 
      Line3DBox[{4187, 1831, 2664, 1835, 2663, 1836, 2740, 2739, 1928, 2734, 
       1929, 4598, 1916, 2726, 4593, 1917, 2727, 1910, 4222, 1911, 4226, 4225,
        1915, 4235, 1937, 4233, 1936, 2748, 2634, 4601, 2746, 1935, 4605, 
       1954, 2764, 1950, 2755, 2756, 1871, 2685, 1869, 2683, 2624, 4200, 1858,
        2689, 4575, 2626, 2687, 1872, 4204, 1874, 4203, 1851, 4191, 4192, 
       1850, 4193, 1846, 2669, 1847, 4568, 2670, 1830, 4187}], 
      Line3DBox[{2661, 1833, 1844, 4567, 2668, 2621, 4566, 4565, 1845, 4574, 
       2625, 2686, 4573, 1863, 1859, 2677, 4571, 1860, 2684, 1870, 2758, 2757,
        1951, 4245, 2761, 1949, 1939, 4603, 2749, 2635, 4234, 2633, 4223, 
       4224, 1912, 2728, 4594, 1918, 1931, 2735, 4232, 1930, 2737, 2738, 1834,
        2662, 1832, 4563, 2661}], 
      Line3DBox[{4189, 1837, 2672, 4196, 1856, 4197, 1854, 2671, 4195, 1855, 
       2674, 1842, 2667, 4190, 1843, 2690, 1849, 1848, 2736, 1932, 2742, 1934,
        4599, 2743, 1924, 2731, 1925, 4597, 2733, 1927, 4230, 1921, 4228, 
       2729, 1922, 4243, 4242, 1946, 4604, 1947, 2753, 4240, 1943, 4237, 1942,
        2751, 4236, 1941, 2750, 1940, 2760, 4244, 1953, 2762, 2763, 1867, 
       2681, 1864, 4572, 2679, 1861, 2678, 1862, 4576, 2692, 1876, 4206, 1877,
        4577, 2694, 2628, 4207, 1838, 4188, 4189}], 
      Line3DBox[{1839, 2665, 1840, 4564, 2666, 1841, 2745, 2744, 4600, 1933, 
       2741, 1913, 2725, 1914, 4229, 2732, 1926, 4231, 1919, 4227, 1920, 2730,
        4596, 4595, 1923, 4602, 2747, 1938, 4239, 1945, 4238, 1944, 2754, 
       4241, 2636, 2752, 1948, 2759, 1952, 4606, 2765, 2766, 1868, 2682, 4201,
        1865, 2680, 1866, 2693, 2627, 4205, 2691, 1875, 4209, 1878, 4208, 
       1873, 2688, 4202, 2622, 4569, 4570, 2673, 1853, 4194, 1852, 4198, 1857,
        2676, 4199, 2623, 2675, 1839}], Line3DBox[CompressedData["
1:eJwl0b8rxHEcx/H3Wc6dy68MykJ+xWIRucVkEqJcWSQLFr9m5R8xuaszYbFc
TCxucRiUS9nIJK4oA4/L8Or5er76fPr2/X57VrcWNhMRsSGFZMRNOuK3LaKC
eX4k93q0RxT1J6nxDK/ot3LQGvFhS9vueIE/Yh4PpapXcLAx4gr78BJ7myI6
3ennA3JtG7CN6C1S4s38x/0vSehntsBvnsSEc13YjTX8lP1UREMmYgdf+bb3
ecFdvifv+rLnLuo5eeY5PqPPyorzVdu8bY6v8RVcxzROYFZS+jgmcBTz7ky5
E/Xny6StaOuon5MlXuJj+rCc6NPOn+IQL2MWz/FCyt7xzXc9xof0///5A+GY
ON8=
       "]], Line3DBox[CompressedData["
1:eJwl0c8rw3Ecx/E3W34MhZuDw4ryKweLnJxc/ChLKbeVolxIXFz9Ee7UFKVs
hb+ATbmQZJI7TloO5NdDDq+er+drn0/ffbf0wursSk1ELMt2a8R1KiJfH3Eg
N3pNe8S+XpEqb+J3+oPknX+ztdge+RF/xSIWpKqfY09DxBn2Yhm7myI63Bnk
fVKyddn69S93TnmSf+rvktBPbLX4weswnO3ENEZzxI++1ej76uv4zNfaIp5w
g2/Kq57z3Kw+Lfc8y6f0Sck5X7HN2Cb4Es/hIiZxGEckoY/it2cP4Y474+58
8U/J2HZtP3+fOzvPj3lGH5CCPmcr/r0zv8AxLGFZLr3ji9/1EG9xD69S///P
L8aQPLU=
       "]], Line3DBox[CompressedData["
1:eJwl0bsrhXEcx/GvcsI5uTxHJpORFBaXgbDYlY7cBiYLg8LC7l+wYNEpJhnk
WCgGZaAOJbfEZLNgcHmdDJ/en/en3+95nnqapueH58oiYlZ2KyKK6YgdvMU9
vMf1uogHPOAFedLLsxGH+rN88Fr+or9K3vkvW2K74Vu8iJu4Idf6BbZXRpxj
B15hSyai0Z0u3imXtmZbq56VI57wRK8rRS/YajHF0/jj2Sn8xS/8lJWqiHdc
xR9cSCK+cYkvy5s+6b05fVQe+Qif0idkxvk727BtnC/yNVzCBuzHAanX+zCL
g5h3Z8idGl4tvbbt0vfrbZLj+7xd75BTfcx2hj28gN14jCeZ///zB9jXOs8=

       "]], Line3DBox[CompressedData["
1:eJwl0b8rxHEcx/G3O+Ec5xgom4mFwY/pzuTHZHKXopRksVCKjGz+CSY/RnQG
FhQbMTCQ3/kbHGHwKMOr5+v56vPpU99v2/T86FxFRMzKXnXEXW3ELj5goini
EUv8QF70pO1If5Myz/AX/VV2shFftqztnW/zG9zAdbnVL7G3JuIKu/EC29MR
re708D65tnXYOvUqOeRpXq1npF4/stVhgtdgElNYiWX8kJVUxCeu4g8uNEZ8
4yJfkl99yrsFvShPvMDH9QmZcf7ZVrRN8kW+hsvYggM4KM36ENZhDjfdGXYn
zRskb9uyZfVOGeMl3qX3y5k+4vw55vkp5vAYT2Tfd7uv/f8/fwLJN/o=
       "]], Line3DBox[CompressedData["
1:eJwl0bkuRGEchvG/WGYGhWUwM7EELRdgSQiJWBsNicqSiAKNOyCRuAFcAo0K
lWRQyhBiqW3RCHoKP1E8ed73zfnOSb7TOrc6uVIUEUvYroo4SkTs8g6O5Tvu
Skbccjc/cGdFRGNNRK/eg3tbh61CLkdeb9bb5AbUySe2NGf0DGe5nnOcqoxI
YisVUcabXMpr1RElvKGvo1ie9d1FeQFPzk/r8/Icljz/aJuyzeor+iovcwuP
8hia5XHO8RDvOTPsTFbPYMS2b2uS2zGjX+j9ch8K8oTnL3lAv+JBvuYbnLu3
1/KIM37jU37mUmdeOK8X8C4n/t4jf+Jbr9U/5C8cuLMfW9p2mPj/P79hQTTh

       "]], Line3DBox[CompressedData["
1:eJwl0UsrhGEchvG/jRlGGadm4VAzkSUbSxaIbGjGjiizcgh7PoL4Ar4CVhYU
KYmFjYUySUqh5KzYiZ8srq77vnue3rf3zRYXCwtlETGD/UTETWXEHr/xejri
nU/1EzzI5bURx/IHvvUG/VP+wrbzP7aM7Vnf0h95kzfwJF9ydzKixD18zZ2p
iBZ3+vReXNk6bBVyEgd6098ZuRk5+dCW5Tq9lus5w438yi9YrohIVEWscJqX
aiKqeU1fRUoueu60PIM7d8b1eXkOs87f2sZsBX1Kz3OR2znPBbTJI9zKo7zp
zpA7OT2LYduGLfn3PpjQz/VBeQAX8qStxP36GXfxDu/iyHe7r/z/P7/GHzjV

       "]], Line3DBox[CompressedData["
1:eJwl0b8rxHEcx/G3AXfnyI8ov0JKSpkMNm6QS5FkUTcR5Ud3VnYm/whXFsV2
MihKGS5KslB+5VhMBnmU4dXz9Xz1+Xy/9f32LRbm8lURsSqntRGPqYgSfmKy
OeILL/ilVPSE7Vp/lx/ezN/0bzlqjPi1tdme+T5/wSIeyKt+h2OJiAccx3sc
rovodifDR6VsG7LV62kp8Q7eo/dLr35m68FW3oJt2I5dWMEP2U5GpNIRe9iA
W02eiTt8V9L6kvcu6yvy5M4CX9M3peD8sy1ny/MNvoHr2IWTmJVOfRYHcB4P
3ZlyZ5D3yrStaKvRqyXHr3hGz8qNPuP8LU7wMo7gMZ7Iue/2mvr/P3+ksTgN

       "]], Line3DBox[CompressedData["
1:eJwl0TsohXEcxvEfpdwGjlzK4La6l6KMFAtFKZmcMpAcUZJL6ZycXVhZkImJ
wcxOncVlsyjnKDabz8nw9H2+T++///v2tiVTUyslEbEoo+URfVURLYmIfhzh
4zKgt9rG9H2Z4918S9+Wj5qIWVunbYd/8TQWMC8Zvbk24g3r8BkTeODMsDMv
/FWabEe2d/1Oyvgav9TPZEkvtS3iOV/FK8xirujVESnpqIzYxAZM4r0z89jI
W2VZT7v3uyLiR2b4Bv/U83Lt+Wnbuq3Ab/gv3uIppjEjJ/pe8Z1xF+ucWXDm
kB9L1lZvO9ef5IJ38Uf9Qdr0Zc+3F9+RD2IOe7C3eL9vmvBtkzhU9f9//gDr
Bzj6
       "]], Line3DBox[CompressedData["
1:eJwl0bsrxXEcxvGPGNwGTq5lEdlkwGGxUhQxyoRFHCcKA7lEsrkVkwxCFAv/
AgZWo0sWl4HVgLxkeHo/76ffp9O3U9mf7hnNiIgheSiIaMiLaM2O6JCkXpmI
aNcXpJfX8nl9ST5832ersy3zL76DP/gtu3pxYcQdFuE9luKmmxY3T/xBSmwb
tkf9WLJ4ih/pBzKiZ9qG8ZCn8QRX8BYn8yMmpDo3YgrLcBAv3AxgOa+QlL7o
d99zIt6kh4/zV/1FTn3fbRuzPfNz/olnuI2zOCdb+gKu4zQWuhl0s8ZXZcaW
sG3o17LPa/iNfiVV+p6tGi95E95iIyb/3uJNXd7Wic3YhvV5///PL6tXOs0=

       "]], Line3DBox[CompressedData["
1:eJwl0U0rhGEchfHbxusskJTBYqZsJ4NSDJ+AkggLFoqyGWFmiRTNzAdg7WVi
QSlbbGVmySdQjLBR3rZ+sjhd5zrd/57FE5tfHk9XhRCWZLQ2hP6GEEZwAMdw
ECuNIaRwis/IkB5vDmFaz8ks7+Z5vSDv3s/ZkrZN/sbX8RVfZEOPNoXwiG34
hJ2452bYzTOvSIdt1/agX0sNz/Ir/VIyerVtDc/5Cp5iGs9wNWKTWL0N45jB
m78bjPJ2WdC3fPejLoRPmeRZ/qN/y4X3E7aM7YuXeMJdGY95DvNS1HfwCAvY
6mbRzQHfl21bi+1Qv5Ui7+IlvSy9+omtD+95Au8wiT2R///zC82EOqI=
       "]], Line3DBox[CompressedData["
1:eJwl0bsrhQEcxvGfRcclYZKBRBkoBjbqnKMom1NKJo5yGbBy5LBYLAaE8h8o
l1yiDAaX+BOIyMLCrlw+ZXj6Pt+n93dOb29ddjozVRARE/JcHpFJRNRURLxh
Lb5jI26XRCQrIz75hzTYtmwH+r6U8WV+pV9KTk/YZvGaz+Mt5vEOF0sjFqS1
2B024RzeuMlhM2+RvL7kfwv1kAE+w3+L/D4/8/ygLWf7sZ3yb7zAI1zFNTnU
1/EYN7DazbibE74rK7Yq255+Ljs8yR/1B+nQJz3fife8F58whWkZ80493m0U
u3EE09jgpguzfFhSer1tSN+SLG/nm/qGfPkGw7Y2Wz9/5X34Uv7/ff4AsBA7
Kg==
       "]], Line3DBox[CompressedData["
1:eJwl0T0oxHEcx/HvTZyH8jDIiI7JYCELg4dkEiKrh7jlbK4LSW5hwmC4szsb
IoNBJoqZRSmxUazO4FWGd+/P5/P//fr3798yuzyeSUREGq91EZOVEe/8him5
rT7ig1v5k9u5WB3R3xDxrX8hZSvYLuRz1Orb+qN8izU5aVvlO32T73mDHzhf
E7GFrirPuJPX+c6dNW7XU8jJee+tkBOY0XP6bzKijEvnp21Z249+ozc6d81n
+h7v41Q+4GPe4SZ3Ft0p6UfYtTXbTuQrlPRe/Ul+RJ+ccb6fn/UBfuEhHkba
N434tiUe5QUe5JQ7Qzyvr2BM7rBl5SLm9G69IB+i7B/M23psE5X//+cPDxo7
jA==
       "]], Line3DBox[CompressedData["
1:eJwl0b0rxAEcx/Hvbe5Qx44sUqQoUsrCYhBZiBiU8hAW2UgGN7oBg4cjVsrD
5Ar5Ay78B4oyEoOnxesyvHt/Pp9+337362rH5wfmEhExhZGSiM7SiGEe5Jd0
xBAv6HPolesqI2blHCb0dv1QPkKiImLS1mHb0r/db/AXf2JTbvDMO9fzBzfz
gZsuN7/6D5ps+7YL+RxlekZ/kO+RlSts63ytL/INr3CBZ8oiplGTiljlFs5y
oXjDbXorMvKa9yblFMb0ZT0tlyPv+VHbku0tGXGqv/IZ33Ku+DtxLe/wFR9w
tZspN3n9Etu2KtuevItjvUd/lp/QJ5/Y+vlR7+Y7buDG4rf4pp7S///nD/f+
PBU=
       "]], Line3DBox[CompressedData["
1:eJwl0T8ohHEcx/EfGbgTTjYJ03mkFBOLbjJcBmQiVwb5U55MlEGJiDvJQqIY
yYyS6FYxWFgNFptINl6X4dP78/70fJ+761on4qG5shDCtIxXhtCXDGEMh7G9
PoQRjPm8DOpttkV9V3K8i+/ox/JbF8Kkrce2yT94Hr/wU7b1KMWxE7+xA4/c
ZNz88Hdpse3ZrvQLSfBV/qQ/S0GvtW3hHV/AIq7gI05V+x7SlAhhDbuxgPel
G0zzSDb0dZ9brlfIKF/iSb1Bip7P2ZZtKX7Da/Aaz6u8C/Nyph/iLZ5gs5sZ
N0V+Kfu2RttBqcsp7+Uv+ptk9djzA/jK+/EB0xjJrN+UTf7/P392dzls
       "]], Line3DBox[CompressedData["
1:eJwl0T8ohHEcx/GvpHBX/pRNcts5KcXEIpPhMlwykcuii7hMlEGJCCdZSBQj
mVES3SoGC6vBYlNHNi8ZPr0/70+/X8/z9KQm53KzVRFRkInaiIFExDiOYGdz
xCgW+bzk9A7bor4ned7Dd/UTiaaIKVufbZN/NkZs4xdWZEfPOFPBbvzGLjx2
Z9CdH/4hKdu+7Vq/lARf5c/6i5T0RtsW3vMFLOMKPmEh6T2krT5iDXuxhA9/
dzDNM7Khr3tutV4jY3yJJ/UWKTufty3bmvktb8AbvKjzbViSc/0I7/AU292Z
dqfMr+TA1mo7/Otyxvv5q/4uWb3o/DC+8SF8xDRmZMY3ZRP//+cXbjc42g==

       "]]}, 
     {GrayLevel[0.2], 
      Line3DBox[{3427, 3425, 4248, 3432, 4266, 3457, 4268, 3460, 4273, 3448, 
       4258, 3443, 4255, 3441, 4253, 3439, 4320, 3506, 4324, 3510, 4339, 4341,
        3534, 4343, 3537, 4349, 3525, 4332, 3520, 4329, 3518, 3516}], 
      Line3DBox[{3431, 3430, 4247, 3429, 4265, 3456, 4270, 3462, 4272, 3450, 
       4260, 3446, 4257, 3445, 4262, 3453, 4323, 3509, 4322, 3508, 4337, 4338,
        3533, 4345, 3539, 4348, 3527, 4334, 3523, 4331, 3522, 3530}], 
      Line3DBox[{3435, 3766, 4615, 3770, 4616, 3436, 4614, 3424, 4609, 3423, 
       4608, 3762, 4612, 3434, 4611, 3765, 4643, 3820, 4647, 3823, 4648, 4649,
        3513, 4646, 3505, 4641, 3504, 4640, 3816, 4642, 3512, 3819}], 
      Line3DBox[{3464, 3781, 4628, 3784, 4630, 3785, 4631, 3451, 4621, 3438, 
       4618, 3772, 4625, 3455, 4624, 3778, 4660, 3834, 4663, 3836, 4665, 4666,
        3837, 4667, 3528, 4655, 3515, 4652, 3825, 4657, 3532, 3831}], 
      Line3DBox[{3465, 3783, 4627, 3459, 4626, 3780, 4629, 3447, 4619, 3774, 
       4620, 3775, 4623, 3452, 4622, 3777, 4661, 3835, 4662, 3536, 4658, 4659,
        3833, 4664, 3524, 4653, 3827, 4654, 3828, 4656, 3529, 3830}], 
      Line3DBox[{3491, 3490, 4309, 3496, 4313, 3502, 4314, 3478, 4294, 3477, 
       4304, 3487, 4301, 3486, 4300, 3485, 4382, 3565, 4387, 3569, 4393, 4394,
        3574, 4395, 3553, 4373, 3552, 4379, 3562, 4378, 3561, 3560}], 
      Line3DBox[{3493, 3492, 4308, 3495, 4317, 3501, 4312, 3476, 4293, 3475, 
       4292, 3474, 4298, 3482, 4302, 3488, 4383, 3566, 4386, 3568, 4399, 4400,
        3573, 4392, 3551, 4372, 3550, 4371, 3549, 4377, 3557, 3563}], 
      Line3DBox[{3500, 3499, 4636, 3809, 4637, 3812, 4638, 3480, 4633, 3473, 
       4632, 3800, 4635, 3484, 4634, 3804, 4672, 3572, 4671, 3858, 4673, 4674,
        3860, 4675, 3555, 4669, 3548, 4668, 3850, 4670, 3559, 3854}], 
      Line3DBox[{3517, 3519, 4330, 3521, 4333, 3526, 4350, 3538, 4344, 3535, 
       4342, 4340, 3511, 4325, 3507, 4321, 3440, 4254, 3442, 4256, 3444, 4259,
        3449, 4274, 3461, 4269, 3458, 4267, 3433, 4249, 3426, 3428}], 
      Line3DBox[{3531, 3832, 4336, 3514, 4328, 3826, 4335, 3829, 4353, 3542, 
       4352, 4351, 3541, 4347, 3540, 4346, 3454, 4263, 3779, 4264, 3437, 4252,
        3773, 4261, 3776, 4276, 3467, 4275, 3466, 4271, 3463, 3782}], 
      Line3DBox[{3544, 3842, 4359, 3545, 4357, 3543, 4356, 3841, 4364, 3546, 
       4363, 4362, 3847, 4365, 3848, 4366, 3469, 4280, 3790, 4284, 3470, 4282,
        3468, 4279, 3789, 4287, 3471, 4286, 3796, 4288, 3797, 3798}], 
      Line3DBox[{3558, 3855, 4381, 3547, 4370, 3851, 4375, 3853, 4401, 3575, 
       4397, 4396, 3571, 4390, 3859, 4391, 3483, 4299, 3805, 4306, 3472, 4291,
        3801, 4296, 3803, 4318, 3503, 4315, 3498, 4311, 3810, 3811}], 
      Line3DBox[{3564, 3856, 4380, 3556, 4376, 3554, 4374, 3852, 4398, 3567, 
       4385, 4384, 3857, 4389, 3570, 4388, 3489, 4303, 3806, 4305, 3481, 4297,
        3479, 4295, 3802, 4316, 3494, 4307, 3807, 4310, 3497, 3808}], 
      Line3DBox[{3609, 3607, 4427, 3603, 4424, 3601, 4434, 3583, 4406, 3581, 
       4410, 3588, 4417, 3594, 4420, 3596, 4500, 3689, 4498, 3685, 4492, 4494,
        3683, 4511, 3665, 4479, 3663, 4483, 3670, 4488, 3676, 3678}], 
      Line3DBox[{3611, 3610, 4428, 3612, 4432, 3615, 4431, 3586, 4408, 3585, 
       4407, 3584, 4414, 3592, 4421, 3597, 4501, 3690, 4502, 3691, 4508, 4509,
        3693, 4507, 3668, 4481, 3667, 4480, 3666, 4485, 3674, 3679}], 
      Line3DBox[{3613, 3599, 4680, 3869, 4682, 3616, 4681, 3577, 4676, 3861, 
       4677, 3864, 4679, 3590, 4678, 3865, 4712, 3681, 4711, 3922, 4714, 4715,
        3694, 4713, 3659, 4708, 3914, 4709, 3917, 4710, 3672, 3918}], 
      Line3DBox[{3640, 3639, 4462, 3645, 4460, 3626, 4449, 3625, 4454, 3634, 
       4455, 3635, 4470, 3653, 4469, 3652, 4536, 3717, 4545, 3720, 4541, 4542,
        3704, 4528, 3703, 4532, 3712, 4533, 3713, 4553, 3727, 3726}], 
      Line3DBox[{3641, 3897, 4696, 3898, 4697, 3900, 4699, 3623, 4688, 3890, 
       4694, 3632, 4693, 3630, 4691, 3893, 4728, 3946, 4729, 3947, 4731, 4732,
        3948, 4734, 3701, 4722, 3939, 4726, 3710, 4725, 3708, 3942}], 
      Line3DBox[{3642, 3638, 4695, 3895, 4700, 3643, 4698, 3622, 4687, 3888, 
       4689, 3891, 4690, 3892, 4692, 3894, 4730, 3716, 4727, 3944, 4735, 4736,
        3718, 4733, 3700, 4721, 3937, 4723, 3940, 4724, 3941, 3943}], 
      Line3DBox[{3647, 3646, 4461, 3644, 4459, 3628, 4450, 3627, 4453, 3633, 
       4456, 3636, 4471, 3654, 4472, 3656, 4544, 3721, 4543, 3719, 4539, 4540,
        3706, 4529, 3705, 4531, 3711, 4534, 3714, 4554, 3728, 3729}], 
      Line3DBox[{3655, 3651, 4705, 3909, 4707, 3657, 4706, 3650, 4703, 3649, 
       4702, 3648, 4701, 3905, 4704, 3908, 4741, 3725, 4740, 3957, 4743, 4744,
        3730, 4742, 3724, 4739, 3723, 4738, 3722, 4737, 3953, 3956}], 
      Line3DBox[{3671, 3919, 4489, 3661, 4477, 3658, 4475, 3915, 4512, 3924, 
       4514, 4513, 3680, 4490, 3923, 4503, 3589, 4411, 3866, 4418, 3579, 4404,
        3576, 4402, 3862, 4435, 3873, 4436, 3598, 4422, 3870, 3872}], 
      Line3DBox[{3673, 3920, 4484, 3921, 4486, 3660, 4476, 3916, 4506, 3692, 
       4505, 4504, 3687, 4496, 3686, 4495, 3591, 4412, 3867, 4413, 3868, 4415,
        3578, 4403, 3863, 4430, 3614, 4429, 3605, 4425, 3604, 3871}], 
      Line3DBox[{3677, 3675, 4487, 3669, 4482, 3662, 4478, 3664, 4510, 3682, 
       4493, 4491, 3684, 4497, 3688, 4499, 3595, 4419, 3593, 4416, 3587, 4409,
        3580, 4405, 3582, 4433, 3600, 4423, 3602, 4426, 3606, 3608}], 
      Line3DBox[{3695, 3928, 4516, 3929, 4518, 3696, 4517, 3930, 4524, 3698, 
       4522, 4521, 3697, 4520, 3933, 4523, 3617, 4438, 3877, 4439, 3878, 4441,
        3618, 4440, 3879, 4445, 3620, 4444, 3619, 4443, 3882, 3886}], 
      Line3DBox[{3709, 3707, 4530, 3702, 4527, 3699, 4526, 3938, 4538, 3949, 
       4547, 4546, 3715, 4535, 3945, 4537, 3631, 4452, 3629, 4451, 3624, 4448,
        3621, 4447, 3889, 4458, 3901, 4463, 3637, 4457, 3896, 3899}], 
      Line3DBox[{3768, 3767, 4613, 3769, 4617, 3771, 4251, 3761, 4246, 3760, 
       4607, 3759, 4250, 3764, 4610, 3763, 4644, 3821, 4645, 3822, 4650, 4651,
        3824, 4327, 3815, 4319, 3814, 4639, 3813, 4326, 3818, 3817}], 
      Line3DBox[{3794, 3793, 4285, 3795, 4289, 3799, 4290, 3788, 4278, 3787, 
       4277, 3786, 4283, 3792, 4281, 3791, 4360, 3845, 4361, 3846, 4367, 4368,
        3849, 4369, 3840, 4355, 3839, 4354, 3838, 4358, 3844, 3843}], 
      Line3DBox[{3884, 3883, 4685, 3885, 4686, 3887, 4446, 3876, 4437, 3875, 
       4683, 3874, 4442, 3881, 4684, 3880, 4717, 3934, 4718, 3935, 4719, 4720,
        3936, 4525, 3927, 4515, 3926, 4716, 3925, 4519, 3932, 3931}], 
      Line3DBox[{3911, 3910, 4468, 3912, 4473, 3913, 4474, 3904, 4465, 3903, 
       4464, 3902, 4467, 3907, 4466, 3906, 4551, 3958, 4552, 3959, 4555, 4556,
        3960, 4557, 3952, 4549, 3951, 4548, 3950, 4550, 3955, 3954}], 
      Line3DBox[{3217, 4165, 3218, 4129, 4103, 4149, 4032, 3750, 4586, 4118, 
       3751, 4599, 4123, 3403, 4600, 4085, 4157, 4109, 4137, 4564, 3289, 4110,
        4190, 3227, 3217}], 
      Line3DBox[{3219, 4166, 3220, 4131, 4104, 3968, 4105, 4148, 4031, 4117, 
       4151, 3351, 4214, 3336, 4146, 3335, 4579, 3745, 4597, 3397, 4229, 4074,
        3396, 3402, 4598, 4155, 4122, 4156, 4079, 3287, 3995, 3285, 4136, 
       4187, 3284, 3288, 4006, 4199, 3309, 4195, 3236, 4168, 3731, 4132, 
       3219}], Line3DBox[{3221, 3961, 3223, 4171, 3970, 3243, 3245, 4175, 
       3974, 3251, 4559, 3249, 4188, 3737, 4569, 4141, 3305, 4191, 3301, 4004,
        4565, 3299, 4002, 3290, 3996, 3292, 3999, 3296, 4083, 4081, 3404, 
       4086, 3393, 4069, 3386, 4223, 4064, 3384, 4225, 3388, 4071, 4595, 3755,
        4242, 3346, 4212, 3748, 4028, 4584, 3348, 3338, 4023, 4581, 3340, 
       4025, 3344, 4037, 3352, 4033, 4035, 3272, 3985, 3230, 3965, 3221}], 
      Line3DBox[{3222, 3962, 3224, 4172, 3971, 3244, 3246, 4176, 3975, 3252, 
       4560, 3250, 4189, 3738, 4570, 4142, 3306, 4192, 3302, 4005, 4566, 3300,
        4003, 3291, 3997, 3293, 4000, 3297, 4084, 4082, 3405, 4087, 3394, 
       4070, 3387, 4224, 4065, 3385, 4226, 3389, 4072, 4596, 3756, 4243, 3347,
        4213, 3749, 4029, 4585, 3349, 3339, 4024, 4582, 3341, 4026, 3345, 
       4038, 3353, 4034, 4036, 3273, 3986, 3231, 3966, 3222}], 
      Line3DBox[{3225, 3226, 4173, 4133, 3972, 3247, 3248, 4174, 3238, 4169, 
       3237, 4196, 3308, 4194, 3307, 4193, 3303, 4139, 4138, 4567, 3739, 3294,
        3998, 3295, 4001, 3298, 4076, 4075, 3401, 4080, 3390, 3391, 4594, 
       4068, 4067, 3382, 4222, 3383, 4227, 3395, 4228, 3744, 4578, 3334, 4211,
        3343, 3342, 4027, 4147, 4583, 3747, 3337, 4039, 3354, 4042, 4043, 
       3229, 3964, 3228, 3963, 3225}], 
      Line3DBox[{3232, 3233, 4167, 4130, 3234, 3973, 3240, 4558, 3969, 3239, 
       3242, 4170, 3241, 4197, 3310, 4198, 4111, 4143, 3304, 4568, 4140, 3283,
        4135, 4563, 3286, 3281, 3994, 3282, 4078, 4077, 3399, 3400, 4232, 
       4154, 3392, 4066, 4593, 3754, 4073, 4121, 4231, 3398, 4230, 3333, 4210,
        3332, 3331, 4022, 4580, 3746, 4030, 3350, 4150, 4587, 3356, 3355, 
       4040, 4041, 3235, 3967, 3232}], 
      Line3DBox[{3253, 4177, 4106, 3732, 4572, 3319, 3320, 4201, 4144, 3321, 
       4102, 4164, 4606, 3758, 4128, 4244, 3380, 3377, 4591, 3378, 4152, 4056,
        3254, 4134, 3253}], 
      Line3DBox[{3256, 3976, 3255, 3991, 3280, 4186, 3990, 3279, 3276, 4184, 
       3987, 3735, 4181, 3271, 4207, 3742, 4202, 4145, 3326, 4203, 3324, 4017,
        4574, 3325, 4019, 3317, 4011, 3313, 4008, 3314, 4094, 4093, 3418, 
       4098, 3420, 4099, 3411, 4234, 4088, 3410, 4235, 3408, 4159, 4602, 3409,
        4604, 3362, 4217, 3363, 4046, 4219, 3365, 3366, 4049, 4589, 3374, 
       4048, 3373, 4060, 3375, 4052, 4053, 3263, 3980, 3256}], 
      Line3DBox[{3257, 3977, 3258, 4562, 3993, 3270, 3268, 4180, 3267, 4206, 
       3329, 4209, 4116, 4021, 3743, 4575, 4018, 4112, 4010, 4571, 3740, 3316,
        4013, 3322, 4091, 4090, 3417, 3422, 4245, 4101, 4124, 4158, 4601, 
       3406, 4162, 4126, 4238, 3414, 4237, 3372, 4220, 3371, 3358, 4044, 4588,
        3359, 4047, 3369, 4058, 4592, 3753, 3381, 4061, 4062, 3262, 3979, 
       3261, 3733, 4179, 3984, 3257}], 
      Line3DBox[{3259, 4178, 4107, 3992, 3269, 4561, 3734, 4576, 3328, 4205, 
       4020, 3323, 3315, 4200, 4009, 4113, 4014, 4114, 4163, 4092, 4127, 4100,
        4605, 3421, 3416, 4089, 4241, 3413, 4236, 3357, 4215, 3752, 4045, 
       4119, 4221, 3379, 4057, 4120, 4153, 4063, 3260, 3978, 4108, 3983, 
       3259}], Line3DBox[{3264, 3981, 3265, 3277, 4185, 3988, 3989, 3278, 
       3274, 4182, 3275, 4183, 3736, 4577, 3330, 4208, 3327, 4204, 4115, 4016,
        4015, 4573, 3741, 3318, 4012, 3311, 4007, 3312, 4097, 4096, 3419, 
       4095, 3412, 3757, 4603, 4161, 4160, 4125, 4233, 3407, 4239, 3415, 4240,
        3360, 4216, 3361, 4218, 3364, 3370, 4050, 4051, 4590, 3368, 3367, 
       4059, 3376, 4054, 4055, 3266, 3982, 3264}]}}},
   VertexNormals->CompressedData["
1:eJzsvXk41Wv3P27KUOYxQ1HInBCh2neaKCQlzQOFijKVEk2UVAqJiAylkooI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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  BoxRatios->{1, 1, 1},
  Boxed->False,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{309.80024596602783`, 305.10418570432},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]]},
  PlotRange->{{-4, 4}, {-4, 4}, {-4, 4}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.621865745483604, -2.9371495103572713`, 0.4389809306051404},
  ViewVertical->{0.16594905563400697`, -0.458836943100985, 
   0.8728857717822673}]], "Output",
 CellChangeTimes->{{3.714070713251281*^9, 
  3.7140707303740835`*^9}},ExpressionUUID->"279d6e60-6f8f-4fc9-b627-\
9a7eeb7c7cc3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 8", "Section",
 CellChangeTimes->{{3.713236030488112*^9, 
  3.7132360333433156`*^9}},ExpressionUUID->"dae64fe3-d030-402a-99bd-\
33d99c0fb7f0"],

Cell[TextData[{
 "Find the magnitude of the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "2", ",", "4"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]],ExpressionUUID->"eb96a642-faac-48da-b8ec-30b495455328"],
 " and give a unit vector in the same direction as ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "458081e1-13b1-40d8-a9df-f7f809dafb3d"],
 "."
}], "Text",
 CellChangeTimes->{{3.713236916043934*^9, 3.7132369632722015`*^9}, 
   3.7134689836990843`*^9, {3.713648970245249*^9, 3.7136489768366575`*^9}, {
   3.7136490086305647`*^9, 3.7136490799425354`*^9}, {3.7140680674593506`*^9, 
   3.7140680700758486`*^9}},ExpressionUUID->"f42c23bc-d166-4763-8758-\
4c71e5ee6cd1"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140716195914755`*^9, 
  3.714071622417471*^9}},ExpressionUUID->"742c8ecd-cc88-40f8-a506-\
42ee5c8a550d"],

Cell["The magnitude is", "Text",
 CellChangeTimes->{{3.7140716195914755`*^9, 3.7140716460492277`*^9}, 
   3.7140716952441826`*^9},ExpressionUUID->"64c6ea21-b681-42fd-a152-\
3e12198d8ea8"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"||", 
    OverscriptBox["v", "\[RightVector]"], "||"}], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "4"}], ")"}], "2"], "+", 
      SuperscriptBox["2", "2"], "+", 
      SuperscriptBox["4", "2"]}]], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{"16", "+", "4", "+", "16"}]], "=", 
     RowBox[{
      SqrtBox["36"], "=", "6"}]}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"cdb2c7b6-7ca7-4533-94d0-02bee0ec1e5a"]], \
"Text",
 CellChangeTimes->{{3.7140716195914755`*^9, 3.7140716460492277`*^9}, {
  3.714071697017362*^9, 3.714071761696376*^9}},
 TextAlignment->Center,ExpressionUUID->"95ddceec-f7f6-40fc-8bb5-db397be0570b"],

Cell["and so a unit vector in the same direction is given by", "Text",
 CellChangeTimes->{{3.7140716195914755`*^9, 3.7140716460492277`*^9}, {
  3.714071697017362*^9, 
  3.7140717747309*^9}},ExpressionUUID->"e692d096-9756-4b86-9350-9492dba70229"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["v", "^"], "=", 
   RowBox[{
    FractionBox[
     OverscriptBox["v", "\[RightVector]"], 
     RowBox[{"||", 
      OverscriptBox["v", "\[RightVector]"], "||"}]], "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", "6"], 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "2", ",", "4"}], "\[RightAngleBracket]"}]}], 
     "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["2", "3"]}], ",", 
       FractionBox["1", "3"], ",", 
       FractionBox["2", "3"]}], "\[RightAngleBracket]"}]}]}]}], 
  TraditionalForm]],
 TextAlignment->Center,
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"dac835f0-8f31-4f9b-b5e2-68a898fd3e53"]], "Text",
 CellChangeTimes->{{3.7140716195914755`*^9, 3.7140716460492277`*^9}, {
  3.714071697017362*^9, 3.7140718593916235`*^9}},
 TextAlignment->Center,ExpressionUUID->"0df5805c-cd3e-4597-a231-55f971345022"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 9", "Section",
 CellChangeTimes->{{3.7132360358875327`*^9, 
  3.7132360371682196`*^9}},ExpressionUUID->"64ce845d-da60-4d4e-bfd3-\
41d25d97b1d1"],

Cell[TextData[{
 "The vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["w", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "837161de-2c7b-412a-b63b-b69d149630d0"],
 " has magnitude 4 and makes an angle of ",
 Cell[BoxData[
  FormBox[
   FractionBox["\[Pi]", "3"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->18,ExpressionUUID->"9dd7e968-c739-40f8-9e4b-0331c8a655fd"],
 " with the positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "928fcb82-d357-431f-8c16-4bea25d5c28c"],
 "-axis. Find ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["w", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "29b42d52-7731-4e17-8275-f648c47f1942"],
 " in component form."
}], "Text",
 CellChangeTimes->{{3.713236968060338*^9, 3.7132369811442337`*^9}, {
  3.713238103378575*^9, 3.7132381044433203`*^9}, {3.7136491318222866`*^9, 
  3.7136491741507063`*^9}, {3.713649210263423*^9, 
  3.7136492725515833`*^9}},ExpressionUUID->"95b56bc2-8c0d-47d9-8d6c-\
692117207b10"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140719008296657`*^9, 
  3.714071903657076*^9}},ExpressionUUID->"f0dcd980-708d-4f63-bfa8-\
6cf0dfc535e0"],

Cell["\<\
Recall that the component form of a vector in the plane can be obtained from \
its magnitude and direction as\
\>", "Text",
 CellChangeTimes->{{3.7140719008296657`*^9, 
  3.714071952733313*^9}},ExpressionUUID->"c7b93f0d-8c80-4449-8c07-\
08fe09203709"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["v", "\[RightVector]"], "=", 
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     RowBox[{"||", 
      OverscriptBox["v", "\[RightVector]"], "||", 
      RowBox[{"cos", " ", "\[Theta]"}]}], ",", 
     RowBox[{"||", 
      OverscriptBox["v", "\[RightVector]"], "||", 
      RowBox[{"sin", " ", "\[Theta]"}]}]}], "\[RightAngleBracket]"}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"c5cc88fc-5cac-4414-91ef-605a6410edd0"]], \
"Text",
 CellChangeTimes->{{3.7140719008296657`*^9, 3.7140720044520454`*^9}},
 TextAlignment->Center,ExpressionUUID->"7cce4f6f-6fdf-42e8-8d72-f7e1b10e09fd"],

Cell[TextData[{
 "where \[Theta] is the angle the vector makes with the positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "66cf729a-9d67-4f42-8dde-2ded774570f6"],
 "-axis. Thus, we have"
}], "Text",
 CellChangeTimes->{{3.7140719008296657`*^9, 3.7140720341419535`*^9}},
 TextAlignment->Left,ExpressionUUID->"d1b3ffc0-4168-47f2-8eb8-8aa313721fe2"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["w", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"4", "cos", " ", 
        FractionBox["\[Pi]", "3"]}], ",", 
       RowBox[{"4", "sin", " ", 
        FractionBox["\[Pi]", "3"]}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{
        RowBox[{"4", 
         RowBox[{"(", 
          FractionBox["1", "2"], ")"}]}], ",", 
        RowBox[{"4", 
         RowBox[{"(", 
          FractionBox[
           SqrtBox["3"], "2"], ")"}]}]}], "\[RightAngleBracket]"}], " ", "=", 
      " ", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"2", ",", 
        RowBox[{"2", 
         SqrtBox["3"]}]}], "\[RightAngleBracket]"}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fb57179f-2a2b-4128-9470-cd378cc83252"],
 "."
}], "Text",
 CellChangeTimes->{{3.7140719008296657`*^9, 3.714072119226319*^9}},
 TextAlignment->Center,ExpressionUUID->"ca13219d-5c9f-4d59-b0f9-549eb54186bb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 10", "Section",
 CellChangeTimes->{{3.713236039199822*^9, 
  3.7132360418072557`*^9}},ExpressionUUID->"bdb4b9e4-e0e4-4ab5-bc41-\
4532cfdc2790"],

Cell[TextData[{
 "Three people located at ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7923c75b-0512-4f22-a4ad-7f86256f40ef"],
 ", ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5d87e71b-a7ed-4372-9e8e-70fd2142ed98"],
 ", and ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "02e34389-8caf-4093-b302-a464a86fff25"],
 " pull on ropes tied to a ring. Find the magnitude and direction of the \
force with which the person at ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "417c92cc-0a89-49c0-99c3-a6eba5804907"],
 " must pull so that no one moves (the system is in equilibrium)."
}], "Text",
 CellChangeTimes->{{3.7132369896523333`*^9, 3.7132370256061144`*^9}, {
  3.7136498172118177`*^9, 3.7136499154061193`*^9}, {3.713650060006056*^9, 
  3.713650102742618*^9}, {3.7136502356555223`*^9, 
  3.713650311688095*^9}},ExpressionUUID->"f48cc877-c2e7-452b-a207-\
13fd886100f0"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQV8W0fSwN1eru3XXq9NmybXNG2apAwhU8zMzMzMzMxsmZmZmdmOMTHG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    "], {{0, 226}, {207, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{207, 226},
  PlotRange->{{0, 207}, {0, 226}}]], "Input",
 TextAlignment->Center,ExpressionUUID->"dffa3e44-63d5-4ea9-8f00-542ffb7c0565"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140722826081963`*^9, 
  3.71407228563866*^9}},ExpressionUUID->"b5fcfb5f-1131-4c67-84eb-\
21e430fff0fa"],

Cell[TextData[{
 "If the system is in equilibrium, we must have ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      OverscriptBox["F", "\[RightVector]"], "1"], "+", 
     SubscriptBox[
      OverscriptBox["F", "\[RightVector]"], "2"], "+", 
     SubscriptBox[
      OverscriptBox["F", "\[RightVector]"], "3"]}], "=", 
    RowBox[{
     OverscriptBox["0", "\[RightVector]"], "."}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d4b89af4-9c46-49a3-8639-beeeed8e1d8d"],
 " This means all of the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a9e488af-3ea3-4547-9ade-748b3d9702e3"],
 "-components and all of the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d39053f7-698d-4708-a874-940876ec2ba1"],
 "-components must also sum to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "aa347e2a-4708-48d4-ba96-4a2aad0dd928"],
 ". Let \[Theta] be the angle that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "3"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1a0ce7e4-b920-42ef-a55a-847cb63371d7"],
 " makes with the positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b5bfa7ef-da67-4a70-90a3-5a83739e6381"],
 "-axis (measured counterclockwise!). Then we have the following equations"
}], "Text",
 CellChangeTimes->{{3.7140722826081963`*^9, 3.714072363809144*^9}, {
  3.714072425284932*^9, 3.7140724435581274`*^9}, {3.7140724935568485`*^9, 
  3.7140725630583496`*^9}},ExpressionUUID->"efa11970-17dd-4377-8038-\
e40de4890344"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{GridBox[{
             {"||"}
            },
            GridBoxAlignment->{"Columns" -> {{"="}}}], 
           SubscriptBox[
            OverscriptBox["F", "\[RightVector]"], "1"]}], "||", 
          RowBox[{
           RowBox[{"cos", " ", "135", "\[Degree]"}], "+"}], "||", 
          SubscriptBox[
           OverscriptBox["F", "\[RightVector]"], "2"], "||", 
          RowBox[{
           RowBox[{"cos", " ", "30", "\[Degree]"}], "+"}], "||", 
          SubscriptBox[
           OverscriptBox["F", "\[RightVector]"], "3"], "||", 
          RowBox[{"cos", " ", "\[Theta]"}]}], "=", "0"}]},
       {
        RowBox[{
         RowBox[{"||", 
          SubscriptBox[
           OverscriptBox["F", "\[RightVector]"], "1"], "||", 
          RowBox[{
           RowBox[{"sin", " ", "135", "\[Degree]"}], "+"}], "||", 
          SubscriptBox[
           OverscriptBox["F", "\[RightVector]"], "2"], "||", 
          RowBox[{
           RowBox[{"sin", " ", "30", "\[Degree]"}], "+"}], "||", 
          SubscriptBox[
           OverscriptBox["F", "\[RightVector]"], "3"], "||", 
          RowBox[{"sin", " ", "\[Theta]"}]}], "=", "0"}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"d273db1b-4199-47b9-941d-3e11a1fa6401"]], \
"Text",
 CellChangeTimes->{{3.7140727039238453`*^9, 
  3.714072724367659*^9}},ExpressionUUID->"58a447bc-c6e1-43de-9363-\
417c5a252690"],

Cell[TextData[{
 "Now we plug in the magnitudes for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "1"], TraditionalForm]],
  ExpressionUUID->"246d5f66-d94d-4aba-a9aa-191918abb656"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "2"], TraditionalForm]],
  ExpressionUUID->"9830bb80-8308-4b49-84ba-8bb54178e37c"],
 " and evaluate the sines and cosines to get"
}], "Text",
 CellChangeTimes->{{3.7140727389403863`*^9, 
  3.7140727879597754`*^9}},ExpressionUUID->"94fcc694-cbb3-46a4-957b-\
1f0b0bd3de97"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "50"}], 
            SqrtBox["2"]}], "+", 
           RowBox[{"30", 
            SqrtBox["3"]}], "+"}], "||", 
          SubscriptBox[
           OverscriptBox["F", "\[RightVector]"], "3"], "||", " ", 
          RowBox[{"cos", " ", "\[Theta]"}]}], "=", "0"}]},
       {
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"50", 
            SqrtBox["2"]}], "+", "30", "+"}], "||", 
          SubscriptBox[
           OverscriptBox["F", "\[RightVector]"], "3"], "||", 
          RowBox[{"sin", " ", "\[Theta]"}]}], "=", "0"}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"9775c63c-8c1d-4fba-bd97-d814fed2e519"]], \
"Text",
 CellChangeTimes->{{3.7140728025443797`*^9, 
  3.714072924162075*^9}},ExpressionUUID->"a04f4e64-953f-4c7e-aaa7-\
12bb164f9445"],

Cell["and moving all the numbers to the right side we have", "Text",
 CellChangeTimes->{{3.7140733449933825`*^9, 
  3.71407335347884*^9}},ExpressionUUID->"d77d05b4-ff66-4ac7-8846-\
382adb6afa81"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {GridBox[{
          {
           RowBox[{
            RowBox[{"||", 
             SubscriptBox[
              OverscriptBox["F", "\[RightVector]"], "3"], "||", " ", 
             RowBox[{"cos", " ", "\[Theta]"}]}], "=", 
            RowBox[{
             RowBox[{"50", 
              SqrtBox["2"]}], "-", 
             RowBox[{"30", 
              SqrtBox["3"]}]}]}]},
          {
           RowBox[{
            RowBox[{"||", 
             SubscriptBox[
              OverscriptBox["F", "\[RightVector]"], "3"], "||", 
             RowBox[{"sin", " ", "\[Theta]"}]}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "50"}], 
              SqrtBox["2"]}], "-", "30"}]}]}
         },
         GridBoxAlignment->{"Columns" -> {{"="}}}]}
      },
      GridBoxAlignment->{"Columns" -> {{"="}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"fcdca4e7-d4a3-47ff-9bc3-c75f84a73c92"]], \
"Text",
 CellChangeTimes->{{3.714073370728118*^9, 
  3.71407340781499*^9}},ExpressionUUID->"c492289d-19e1-46ed-b229-\
7181bf36ceac"],

Cell[TextData[{
 "This gives us the components of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "3"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4f129ecf-f166-4ac1-b533-9dfd4be91a55"],
 ":"
}], "Text",
 CellChangeTimes->{{3.714073422963477*^9, 
  3.7140735199070263`*^9}},ExpressionUUID->"a4a5b666-93be-4693-ad84-\
caa00324d141"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "3"], "=", 
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     RowBox[{
      RowBox[{"50", 
       SqrtBox["2"]}], "-", 
      RowBox[{"30", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "50"}], 
       SqrtBox["2"]}], "-", "30"}]}], "\[RightAngleBracket]"}]}], 
  TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"96bc1bd5-4a02-4afe-a588-045e96971dd9"]], \
"Text",
 CellChangeTimes->{{3.714073422963477*^9, 3.7140736004832487`*^9}, {
  3.714073653156327*^9, 3.714073690969495*^9}},
 TextAlignment->Center,ExpressionUUID->"d6fe8c9e-2573-440d-840c-cb666b1edfa8"],

Cell["and from here we can compute the magnitude and direction:", "Text",
 CellChangeTimes->{{3.7140736162655563`*^9, 
  3.714073637907179*^9}},ExpressionUUID->"fc4ccb99-d223-4b55-ba3b-\
5943a5d3ec34"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{GridBox[{
     {
      RowBox[{
       RowBox[{"||", 
        SubscriptBox[
         OverscriptBox["F", "\[RightVector]"], "3"], "||"}], "=", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"50", 
             SqrtBox["2"]}], "-", 
            RowBox[{"30", 
             SqrtBox["3"]}]}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "50"}], 
             SqrtBox["2"]}], "-", "30"}], ")"}], "2"]}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{"="}}}], "\[TildeTilde]", "102.44"}], 
  TraditionalForm]],
 TextAlignment->
  Center,ExpressionUUID->"57b650a4-8523-4bf6-87b7-dd631aff344f"]], "Text",
 CellChangeTimes->{{3.714073700842579*^9, 3.7140737468512545`*^9}, {
  3.714073795850584*^9, 3.714073835247672*^9}},
 TextAlignment->Center,ExpressionUUID->"775f1091-fe8e-4cfa-8955-ea1f3b6edc8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  FormBox[
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"50", 
         SqrtBox["2"]}], "-", 
        RowBox[{"30", 
         SqrtBox["3"]}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "50"}], 
         SqrtBox["2"]}], "-", "30"}], ")"}], "2"]}]],
   TraditionalForm], "]"}]], "Input",
 CellChangeTimes->{{3.7140737642199974`*^9, 
  3.7140737778711457`*^9}},ExpressionUUID->"983a0395-d0be-4223-b12f-\
41211653a25c"],

Cell[BoxData["102.44106334263498`"], "Output",
 CellChangeTimes->{
  3.714073780009542*^9},ExpressionUUID->"c1d1e63e-bd98-4dc2-97de-\
2b6f432f5633"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"tan", " ", "\[Theta]"}], " ", "=", " ", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "50"}], 
       SqrtBox["2"]}], "-", 
      RowBox[{"30", 
       SqrtBox["3"]}]}], 
     RowBox[{
      RowBox[{"50", 
       SqrtBox["2"]}], "-", 
      RowBox[{"30", 
       SqrtBox["3"]}]}]]}], TraditionalForm]],
  TextAlignment->Center,
  FormatType->"TraditionalForm",ExpressionUUID->
  "2ad68e43-ee3b-46f8-a59f-498b9f249580"],
 " \[Implies] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     RowBox[{"arctan", "(", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "50"}], 
         SqrtBox["2"]}], "-", 
        RowBox[{"30", 
         SqrtBox["3"]}]}], 
       RowBox[{
        RowBox[{"50", 
         SqrtBox["2"]}], "-", 
        RowBox[{"30", 
         SqrtBox["3"]}]}]], ")"}], "\[TildeTilde]", 
     RowBox[{"278.69", "\[Degree]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "175e8b30-d393-494b-92ee-ddd06fca02b1"]
}], "Text",
 CellChangeTimes->{{3.714073853597821*^9, 3.714073949415802*^9}, {
  3.7140742808202085`*^9, 3.714074327807019*^9}},
 TextAlignment->Center,ExpressionUUID->"c8a5ff11-44c5-4623-b0bd-017025220c0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"ArcTan", "[", 
    FormBox[
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "50"}], 
        SqrtBox["2"]}], "-", 
       RowBox[{"30", 
        SqrtBox["3"]}]}], 
      RowBox[{
       RowBox[{"50", 
        SqrtBox["2"]}], "-", 
       RowBox[{"30", 
        SqrtBox["3"]}]}]],
     TraditionalForm], "]"}], "]"}], "+", 
  RowBox[{"2", "\[Pi]"}]}]], "Input",
 CellChangeTimes->{{3.714073970245522*^9, 3.7140739762086515`*^9}, {
  3.7140741380846853`*^9, 
  3.714074247236286*^9}},ExpressionUUID->"2084350a-5d8d-48a0-b08c-\
a81874e8ab50"],

Cell[BoxData["4.864054748400049`"], "Output",
 CellChangeTimes->{
  3.714073978435691*^9, 3.7140741428581104`*^9, 3.7140741744873505`*^9, {
   3.714074207804328*^9, 
   3.714074250004269*^9}},ExpressionUUID->"08e35418-3041-434a-87c7-\
b77e8e4bec8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", "=", 
     RowBox[{"N", "[", 
      FractionBox["4.864054748400049`", "\[Degree]"], "]"}]}], "}"}], ",", 
   RowBox[{"Defer", "[", 
    RowBox[{"d", " ", "\[Degree]"}], "]"}]}], "]"}]], "Input",
 NumberMarks->False,ExpressionUUID->"4a2702e7-3ede-487b-ae5e-658a9ca929f8"],

Cell[BoxData[
 RowBox[{"278.6898084038903`", " ", "\[Degree]"}]], "Output",
 CellChangeTimes->{
  3.7140742566261525`*^9},ExpressionUUID->"e981a349-b55c-49a4-b8e5-\
c16a9a9e0830"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 11", "Section",
 CellChangeTimes->{{3.713236043904008*^9, 
  3.713236045023195*^9}},ExpressionUUID->"feb30fc7-7eb1-49f5-9026-\
f00ef675d0a8"],

Cell["\<\
Use the figure to determine whether each statement is true or false. Justify \
your answer.\
\>", "Text",
 CellChangeTimes->{{3.7132370804592648`*^9, 3.713237151603834*^9}, {
   3.7132371849388576`*^9, 3.713237188708766*^9}, 3.713237221809761*^9, {
   3.713468989450657*^9, 3.713468996554131*^9}, {3.7136511180228157`*^9, 
   3.7136511403920093`*^9}},ExpressionUUID->"664b5388-9817-4cb3-be39-\
505b6a391a10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Thick", ",", "Blue", ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", "Black", ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(a\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2"}], ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(b\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(c\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1", ",", "0.8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(d\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(s\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1", ",", "0.8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(t\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(u\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "0.25"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "0.25"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*OverscriptBox[\(w\), \(\[RightVector]\)]\)\>\"", ",", 
         "Large"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Gray", ",", "Dashed"}], 
     "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.713651193599332*^9, 3.7136513189544764`*^9}, {
  3.7136514250613127`*^9, 3.713651495061314*^9}, {3.7136521643328047`*^9, 
  3.713652283362743*^9}, {3.7136523325389633`*^9, 3.713652591660866*^9}, {
  3.7136526222083054`*^9, 
  3.7136526995672317`*^9}},ExpressionUUID->"e320f4cf-b144-4eb2-94a5-\
a324301b0816"],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 0, 1], Thickness[Large], ArrowBox[{{0, 0}, {0, 2}}], 
   ArrowBox[{{0, 0}, {2, 0}}], ArrowBox[{{0, 0}, {2, 2}}], 
   ArrowBox[{{2, 2}, {0, 2}}], ArrowBox[{{2, 2}, {2, 0}}], 
   ArrowBox[{{2, 0}, {4, 2}}], ArrowBox[{{4, 2}, {2, 2}}], 
   ArrowBox[{{4, 0}, {2, 0}}], ArrowBox[{{4, 0}, {4, 2}}], 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(a\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {-0.2, 1}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(b\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {1, 2.2}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(c\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {1.1, 0.8}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(d\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {2.2, 1}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(s\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {3.1, 0.8}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(t\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {3, 2.2}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(u\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {1, -0.25}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(v\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {3, -0.25}], InsetBox[
     StyleBox["\<\"\\!\\(\\*OverscriptBox[\\(w\\), \\(\[RightVector]\\)]\\)\"\
\>",
      StripOnInput->False,
      FontSize->Large], {4.2, 1}]}},
  GridLines->Automatic,
  GridLinesStyle->Directive[
    Opacity[0.5], 
    GrayLevel[0.5], 
    Dashing[{Small, Small}]],
  PlotRange->{{-1, 5}, {-1, 3}}]], "Output",
 CellChangeTimes->{
  3.713651324311097*^9, 3.713651436428483*^9, {3.7136514805484843`*^9, 
   3.713651495603699*^9}, {3.7136522295725565`*^9, 3.71365228475025*^9}, {
   3.7136523516056523`*^9, 3.7136524362558317`*^9}, {3.713652526470456*^9, 
   3.7136525575334325`*^9}, 3.713652592522769*^9, {3.7136526319157257`*^9, 
   3.713652651028242*^9}, {3.7136526811473446`*^9, 
   3.713652700731844*^9}},ExpressionUUID->"d0cc16e6-53c3-4659-a05a-\
86832d62d5b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["a", "\[RightVector]"], "=", 
   RowBox[{"-", 
    OverscriptBox["d", "\[RightVector]"]}]}], 
  TraditionalForm]],ExpressionUUID->"c82dd88f-6514-4dcb-96d9-d25dfd44b959"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7136527754100695`*^9, 
  3.7136527960406075`*^9}},ExpressionUUID->"bbb2cbe1-53b1-4b50-87f3-\
395d1aca7925"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "+", 
    OverscriptBox["u", "\[RightVector]"]}], "=", 
   OverscriptBox["c", "\[RightVector]"]}], 
  TraditionalForm]],ExpressionUUID->"4673cb64-bfc9-4af7-9a82-446be84358f8"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7136527754100695`*^9, 
  3.713652817704442*^9}},ExpressionUUID->"9f12dccf-5ec2-442e-9944-\
f24940b8f19f"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["a", "\[RightVector]"], "+", 
    OverscriptBox["d", "\[RightVector]"]}], "=", 
   OverscriptBox["0", "\[RightVector]"]}], 
  TraditionalForm]],ExpressionUUID->"38cb885d-9c6c-4500-883d-84efa384af2d"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7136527754100695`*^9, 
  3.7136528413768144`*^9}},ExpressionUUID->"99e92daa-4e3c-4a20-9d5a-\
289385bc92bf"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["c", "\[RightVector]"], "=", 
   OverscriptBox["s", "\[RightVector]"]}], 
  TraditionalForm]],ExpressionUUID->"176db6e1-f82d-4213-b9dd-3f6d4fec4a17"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7136527754100695`*^9, 
  3.713652859336981*^9}},ExpressionUUID->"9297d489-436f-4f6a-9c57-\
2abd44e0f7b6"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "+", 
    OverscriptBox["w", "\[RightVector]"]}], "=", 
   RowBox[{"-", 
    OverscriptBox["s", "\[RightVector]"]}]}], 
  TraditionalForm]],ExpressionUUID->"bf4be6f8-da12-4b3c-8940-edbb99ef8848"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7136527754100695`*^9, 
  3.713652882545216*^9}},ExpressionUUID->"97676775-9656-4de2-82eb-\
115eab623682"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "-", 
    OverscriptBox["v", "\[RightVector]"]}], "=", 
   RowBox[{
    RowBox[{"-", "2"}], 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["b", "\[RightVector]"], "+", 
      OverscriptBox["t", "\[RightVector]"]}], ")"}]}]}], 
  TraditionalForm]],ExpressionUUID->"efb57ea3-6d55-4000-a464-b712da2a8cea"]], \
"ItemNumbered",
 CellChangeTimes->{{3.7136527754100695`*^9, 
  3.7136529090733886`*^9}},ExpressionUUID->"48774b19-010e-492d-a717-\
c20eb535a860"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7140743481477585`*^9, 
  3.7140743512023425`*^9}},ExpressionUUID->"99ab5507-695d-4230-9542-\
1f9b7d644efa"],

Cell[CellGroupData[{

Cell["\<\
True since the two vectors have the same magnitude but opposite directions.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.7140743481477585`*^9, 3.7140743868133483`*^9}, 
   3.7140744576562524`*^9, {3.714074737148946*^9, 
   3.71407474913386*^9}},ExpressionUUID->"4b279b4e-8694-48a0-a1fc-\
ed7f2a2656d0"],

Cell[TextData[{
 "True. ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "21ca6b4e-4974-4c3b-9f6e-95c38e4ed97c"],
 " will the the resultant vector in the parallelogram law."
}], "ItemNumbered",
 CellChangeTimes->{{3.7140743481477585`*^9, 3.714074463385833*^9}, {
  3.714074765245059*^9, 
  3.714074784869671*^9}},ExpressionUUID->"2c32b760-3ebd-4645-ab89-\
6e19a13e31ad"],

Cell["True. This has the same explanation as 1.", "ItemNumbered",
 CellChangeTimes->{{3.7140743481477585`*^9, 3.7140744701528397`*^9}, 
   3.714074790060654*^9, {3.7140748209501762`*^9, 
   3.714074842606612*^9}},ExpressionUUID->"c970b99b-5c05-480a-becf-\
b437d378d6f3"],

Cell["True. They both have the same magnitude and direction.", "ItemNumbered",
 CellChangeTimes->{{3.7140743481477585`*^9, 3.714074478712098*^9}, 
   3.7140748475332065`*^9, {3.714074948912985*^9, 
   3.714074956455163*^9}},ExpressionUUID->"2478a90f-a26d-47ca-b9b5-\
8270e11261d9"],

Cell[TextData[{
 "False. Making the parallelogram out of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f58f40a4-9a5e-4b37-8e12-83d9a21cd8f7"],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["w", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5467acf6-07f0-4cb5-a2a5-5ffacc810d6f"],
 " we see that ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["s", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d9e20ccb-02de-4c47-aeeb-cdff0cb64231"],
 " is the opposite diagonal as the sum of the two."
}], "ItemNumbered",
 CellChangeTimes->{{3.7140743481477585`*^9, 3.7140745021429367`*^9}, {
  3.7140746894853287`*^9, 3.714074690125168*^9}, {3.714074959727393*^9, 
  3.7140750282902827`*^9}},ExpressionUUID->"b9846e75-34d7-4e31-be24-\
e9bc23e27f68"],

Cell[TextData[{
 "False. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["u", "\[RightVector]"], "-", 
     OverscriptBox["v", "\[RightVector]"]}], "=", 
    RowBox[{"2", 
     OverscriptBox["u", "\[RightVector]"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8f730742-1586-4669-a1c0-9031f8eab03b"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["b", "\[RightVector]"], "+", 
       OverscriptBox["t", "\[RightVector]"]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         OverscriptBox["u", "\[RightVector]"]}], "-", 
        OverscriptBox["u", "\[RightVector]"]}], ")"}]}], "=", 
     RowBox[{"4", 
      OverscriptBox["u", "\[RightVector]"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ead3c75a-a2c1-47e0-a774-9c677a4ffb5f"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.7140743481477585`*^9, 3.714074501759136*^9}, {
  3.7140745407993298`*^9, 3.7140745428389215`*^9}, {3.714075038368058*^9, 
  3.7140751288896627`*^9}},ExpressionUUID->"7b271806-f2b9-4fae-917c-\
c90a3d7a40cb"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 231, 4, 101, "Title", "ExpressionUUID" -> \
"c24b517c-552b-406f-9dac-a4c9c95d2e6f"],
Cell[CellGroupData[{
Cell[836, 30, 439, 9, 115, "Chapter", "ExpressionUUID" -> \
"3b3ec95f-b1ce-4b6e-977d-f0b8396bea16"],
Cell[1278, 41, 383, 7, 30, "Text", "ExpressionUUID" -> \
"53cb2384-9edb-4dfb-88fa-93e01824c7ff"],
Cell[CellGroupData[{
Cell[1686, 52, 397, 10, 19, "Code", "ExpressionUUID" -> \
"e75bf68b-4f99-4eee-8d77-ed85dc01727e",
 CellOpen->False],
Cell[2086, 64, 801, 20, 30, "Output", "ExpressionUUID" -> \
"69e77db0-168b-4e50-8235-81048ace3a84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2924, 89, 207, 4, 70, "Section", "ExpressionUUID" -> \
"35567a16-1ed4-4797-8f13-92098861f631"],
Cell[3134, 95, 529, 9, 30, "Text", "ExpressionUUID" -> \
"7fb91719-4e63-4018-adac-6959aff764bd"],
Cell[CellGroupData[{
Cell[3688, 108, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"423aac1f-1e80-47d8-8ba0-2883ebaf50eb"],
Cell[3847, 113, 3412, 64, 269, "Input", "ExpressionUUID" -> \
"f493bc6b-76c4-46bc-b6f3-5bc1844150ee"],
Cell[7262, 179, 3472, 65, 268, "Input", "ExpressionUUID" -> \
"72ff3892-417e-4db9-938b-1593404b20e6"],
Cell[10737, 246, 3841, 71, 280, "Input", "ExpressionUUID" -> \
"b99f2f6d-0b02-4067-b392-9f6cf90d8685"],
Cell[14581, 319, 4032, 74, 258, "Input", "ExpressionUUID" -> \
"81a70880-e02c-4e64-8cd2-e7b880068d5d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18662, 399, 158, 3, 70, "Section", "ExpressionUUID" -> \
"4c5e5fac-f9d1-4582-85e7-aae1b80ee58c"],
Cell[18823, 404, 1152, 22, 49, "Text", "ExpressionUUID" -> \
"aa1e9aea-6bf7-4e24-9592-72c1e553688c"],
Cell[CellGroupData[{
Cell[20000, 430, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"47b45be3-9520-43e1-9413-26b40c36e928"],
Cell[CellGroupData[{
Cell[20185, 437, 1739, 50, 50, "Input", "ExpressionUUID" -> \
"48b38c26-5d09-4f75-993f-83b27af2e186"],
Cell[21927, 489, 801, 20, 393, "Output", "ExpressionUUID" -> \
"12f583c3-5977-4d69-8fc2-30ee4f5b1eca"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22789, 516, 156, 3, 70, "Section", "ExpressionUUID" -> \
"f543dadf-8438-41be-890b-ae304b74c7c1"],
Cell[22948, 521, 2875, 74, 116, "Text", "ExpressionUUID" -> \
"0ba135e6-18c1-4df9-8cbc-613c38b69a26",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[25848, 599, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"f4754c4d-c4b6-4efc-a3d6-c2c7e95060c4"],
Cell[CellGroupData[{
Cell[26031, 606, 2413, 78, 126, "Input", "ExpressionUUID" -> \
"57580ace-2ceb-47fc-8e33-b906cc6d5ee7"],
Cell[28447, 686, 576, 12, 417, "Output", "ExpressionUUID" -> \
"88917706-9bab-44aa-8e65-beddf4f65ae6"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29084, 705, 156, 3, 70, "Section", "ExpressionUUID" -> \
"d9f59dcc-177e-49cd-b037-24d5bddbc1a0"],
Cell[29243, 710, 1692, 45, 78, "Text", "ExpressionUUID" -> \
"896178d9-5051-44e2-b0a9-899683fefc89"],
Cell[CellGroupData[{
Cell[30960, 759, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"9b44d4a6-824b-41e4-9bc4-97e2024e4512"],
Cell[31123, 764, 784, 22, 35, "Text", "ExpressionUUID" -> \
"c306f4ee-87db-4876-8cc0-6b871b529049"],
Cell[CellGroupData[{
Cell[31932, 790, 2107, 63, 107, "Input", "ExpressionUUID" -> \
"443ab6b0-9445-4aea-ba2a-78a1291d5f1c"],
Cell[34042, 855, 809, 20, 395, "Output", "ExpressionUUID" -> \
"70d1b73d-45fb-4a25-9f8b-4bc570a42f53"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34912, 882, 181, 3, 70, "Section", "ExpressionUUID" -> \
"8a849707-7d64-4ab6-84bd-d2ca7003e56a"],
Cell[35096, 887, 849, 22, 30, "Text", "ExpressionUUID" -> \
"d0a72e3d-74b0-4b4a-8ba4-78752449ee25"],
Cell[CellGroupData[{
Cell[35970, 913, 211, 4, 49, "Subsection", "ExpressionUUID" -> \
"c32c33fe-6c37-4f48-a254-6951cc1866ee"],
Cell[36184, 919, 300, 7, 30, "Text", "ExpressionUUID" -> \
"271c9d8e-ed57-43c7-b78f-fbf248d14773"],
Cell[36487, 928, 1119, 32, 32, "Text", "ExpressionUUID" -> \
"966b3234-9708-47df-a47a-6597776c2d4b"],
Cell[37609, 962, 364, 7, 30, "Text", "ExpressionUUID" -> \
"b44f1d23-fa01-4cbd-b2f8-52c6130e4f7e"],
Cell[37976, 971, 707, 19, 32, "Text", "ExpressionUUID" -> \
"ea703166-a855-4ea2-a02c-a677c4c20208"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38732, 996, 153, 3, 70, "Section", "ExpressionUUID" -> \
"9b176684-111d-4f29-bacc-264336849fa2"],
Cell[38888, 1001, 741, 20, 32, "Text", "ExpressionUUID" -> \
"39594a9e-f325-4236-abf3-e2f0761de3dd"],
Cell[CellGroupData[{
Cell[39654, 1025, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"7ce36950-6f94-4fe7-bd0e-7029a7a5cce9"],
Cell[39813, 1030, 751, 21, 30, "Text", "ExpressionUUID" -> \
"7fc82de7-8379-4d3e-9b6a-d5654dc9f5fe"],
Cell[40567, 1053, 161, 2, 30, "Text", "ExpressionUUID" -> \
"6594702e-f0a8-4d26-a262-2963f54ed661"],
Cell[40731, 1057, 2496, 76, 106, "Text", "ExpressionUUID" -> \
"cfbbc5f6-a610-49a5-81fe-6189c73958b9"],
Cell[43230, 1135, 452, 12, 32, "Text", "ExpressionUUID" -> \
"33a46428-5e62-431c-a746-41f94d3b9173"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43731, 1153, 156, 3, 70, "Section", "ExpressionUUID" -> \
"213b8a14-dd5d-4c8b-839d-d0746db10921"],
Cell[43890, 1158, 2385, 56, 165, "Text", "ExpressionUUID" -> \
"140bdf55-ab75-4f74-9e26-7f21c5377a32"],
Cell[CellGroupData[{
Cell[46300, 1218, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"3e299192-f786-4259-b6fd-92f85ff569f8"],
Cell[46459, 1223, 846, 22, 49, "Text", "ExpressionUUID" -> \
"c3769bfe-97e0-4039-a440-69f3f4b60280"],
Cell[CellGroupData[{
Cell[47330, 1249, 1182, 37, 30, "Input", "ExpressionUUID" -> \
"474697e6-5157-4ac8-96ae-139866b59a77"],
Cell[48515, 1288, 170774, 2770, 353, "Output", "ExpressionUUID" -> \
"279d6e60-6f8f-4fc9-b627-9a7eeb7c7cc3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[219350, 4065, 156, 3, 70, "Section", "ExpressionUUID" -> \
"dae64fe3-d030-402a-99bd-33d99c0fb7f0"],
Cell[219509, 4070, 869, 21, 33, "Text", "ExpressionUUID" -> \
"f42c23bc-d166-4763-8758-4c71e5ee6cd1"],
Cell[CellGroupData[{
Cell[220403, 4095, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"742c8ecd-cc88-40f8-a506-42ee5c8a550d"],
Cell[220564, 4100, 187, 3, 30, "Text", "ExpressionUUID" -> \
"64c6ea21-b681-42fd-a152-3e12198d8ea8"],
Cell[220754, 4105, 779, 23, 42, "Text", "ExpressionUUID" -> \
"95ddceec-f7f6-40fc-8bb5-db397be0570b"],
Cell[221536, 4130, 245, 3, 30, "Text", "ExpressionUUID" -> \
"e692d096-9756-4b86-9350-9492dba70229"],
Cell[221784, 4135, 1005, 28, 52, "Text", "ExpressionUUID" -> \
"0df5805c-cd3e-4597-a231-55f971345022"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[222838, 4169, 158, 3, 70, "Section", "ExpressionUUID" -> \
"64ce845d-da60-4d4e-bfd3-41d25d97b1d1"],
Cell[222999, 4174, 1108, 30, 42, "Text", "ExpressionUUID" -> \
"95b56bc2-8c0d-47d9-8d6c-692117207b10"],
Cell[CellGroupData[{
Cell[224132, 4208, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"f0dcd980-708d-4f63-bfa8-6cf0dfc535e0"],
Cell[224293, 4213, 261, 6, 30, "Text", "ExpressionUUID" -> \
"c7b93f0d-8c80-4449-8c07-08fe09203709"],
Cell[224557, 4221, 678, 17, 37, "Text", "ExpressionUUID" -> \
"7cce4f6f-6fdf-42e8-8d72-f7e1b10e09fd"],
Cell[225238, 4240, 407, 9, 30, "Text", "ExpressionUUID" -> \
"d1b3ffc0-4168-47f2-8eb8-8aa313721fe2"],
Cell[225648, 4251, 1086, 32, 53, "Text", "ExpressionUUID" -> \
"ca13219d-5c9f-4d59-b0f9-549eb54186bb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[226783, 4289, 157, 3, 70, "Section", "ExpressionUUID" -> \
"bdb4b9e4-e0e4-4ab5-bc41-4532cfdc2790"],
Cell[226943, 4294, 1094, 28, 49, "Text", "ExpressionUUID" -> \
"f48cc877-c2e7-452b-a207-13fd886100f0"],
Cell[228040, 4324, 24682, 408, 241, "Input", "ExpressionUUID" -> \
"dffa3e44-63d5-4ea9-8f00-542ffb7c0565"],
Cell[CellGroupData[{
Cell[252747, 4736, 157, 3, 49, "Subsection", "ExpressionUUID" -> \
"b5fcfb5f-1131-4c67-84eb-21e430fff0fa"],
Cell[252907, 4741, 1765, 48, 54, "Text", "ExpressionUUID" -> \
"efa11970-17dd-4377-8038-e40de4890344"],
Cell[254675, 4791, 1597, 44, 62, "Text", "ExpressionUUID" -> \
"58a447bc-c6e1-43de-9363-417c5a252690"],
Cell[256275, 4837, 590, 17, 35, "Text", "ExpressionUUID" -> \
"94fcc694-cbb3-46a4-957b-1f0b0bd3de97"],
Cell[256868, 4856, 1060, 33, 64, "Text", "ExpressionUUID" -> \
"a04f4e64-953f-4c7e-aaa7-12bb164f9445"],
Cell[257931, 4891, 195, 3, 30, "Text", "ExpressionUUID" -> \
"d77d05b4-ff66-4ac7-8846-382adb6afa81"],
Cell[258129, 4896, 1173, 36, 64, "Text", "ExpressionUUID" -> \
"c492289d-19e1-46ed-b229-7181bf36ceac"],
Cell[259305, 4934, 399, 12, 35, "Text", "ExpressionUUID" -> \
"a4a5b666-93be-4693-ad84-caa00324d141"],
Cell[259707, 4948, 727, 22, 43, "Text", "ExpressionUUID" -> \
"d6fe8c9e-2573-440d-840c-cb666b1edfa8"],
Cell[260437, 4972, 201, 3, 30, "Text", "ExpressionUUID" -> \
"fc4ccb99-d223-4b55-ba3b-5943a5d3ec34"],
Cell[260641, 4977, 1009, 30, 61, "Text", "ExpressionUUID" -> \
"775f1091-fe8e-4cfa-8955-ea1f3b6edc8a"],
Cell[CellGroupData[{
Cell[261675, 5011, 576, 21, 57, "Input", "ExpressionUUID" -> \
"983a0395-d0be-4223-b12f-41211653a25c"],
Cell[262254, 5034, 148, 3, 30, "Output", "ExpressionUUID" -> \
"c1d1e63e-bd98-4dc2-97de-2b6f432f5633"]
}, Open  ]],
Cell[262417, 5040, 1292, 44, 56, "Text", "ExpressionUUID" -> \
"c8a5ff11-44c5-4623-b0bd-017025220c0b"],
Cell[CellGroupData[{
Cell[263734, 5088, 618, 22, 58, "Input", "ExpressionUUID" -> \
"2084350a-5d8d-48a0-b08c-a81874e8ab50"],
Cell[264355, 5112, 249, 5, 30, "Output", "ExpressionUUID" -> \
"08e35418-3041-434a-87c7-b77e8e4bec8e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264641, 5122, 352, 9, 44, "Input", "ExpressionUUID" -> \
"4a2702e7-3ede-487b-ae5e-658a9ca929f8"],
Cell[264996, 5133, 179, 4, 30, "Output", "ExpressionUUID" -> \
"e981a349-b55c-49a4-b8e5-c16a9a9e0830"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[265236, 5144, 155, 3, 70, "Section", "ExpressionUUID" -> \
"feb30fc7-7eb1-49f5-9026-f00ef675d0a8"],
Cell[265394, 5149, 418, 8, 30, "Text", "ExpressionUUID" -> \
"664b5388-9817-4cb3-be39-505b6a391a10"],
Cell[CellGroupData[{
Cell[265837, 5161, 5552, 166, 19, "Input", "ExpressionUUID" -> \
"e320f4cf-b144-4eb2-94a5-a324301b0816",
 CellOpen->False],
Cell[271392, 5329, 2392, 57, 256, "Output", "ExpressionUUID" -> \
"d0cc16e6-53c3-4659-a05a-86832d62d5b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[273821, 5391, 385, 10, 35, "ItemNumbered", "ExpressionUUID" -> \
"bbb2cbe1-53b1-4b50-87f3-395d1aca7925"],
Cell[274209, 5403, 426, 11, 32, "ItemNumbered", "ExpressionUUID" -> \
"9f12dccf-5ec2-442e-9944-f24940b8f19f"],
Cell[274638, 5416, 428, 11, 35, "ItemNumbered", "ExpressionUUID" -> \
"99e92daa-4e3c-4a20-9d5a-289385bc92bf"],
Cell[275069, 5429, 363, 9, 32, "ItemNumbered", "ExpressionUUID" -> \
"9297d489-436f-4f6a-9c57-2abd44e0f7b6"],
Cell[275435, 5440, 446, 12, 32, "ItemNumbered", "ExpressionUUID" -> \
"97676775-9656-4de2-82eb-115eab623682"],
Cell[275884, 5454, 561, 16, 41, "ItemNumbered", "ExpressionUUID" -> \
"48774b19-010e-492d-a717-c20eb535a860"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276482, 5475, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"99ab5507-695d-4230-9542-1f9b7d644efa"],
Cell[CellGroupData[{
Cell[276667, 5482, 311, 6, 30, "ItemNumbered", "ExpressionUUID" -> \
"4b279b4e-8694-48a0-a1fc-ed7f2a2656d0"],
Cell[276981, 5490, 461, 12, 32, "ItemNumbered", "ExpressionUUID" -> \
"2c32b760-3ebd-4645-ab89-6e19a13e31ad"],
Cell[277445, 5504, 270, 4, 30, "ItemNumbered", "ExpressionUUID" -> \
"c970b99b-5c05-480a-becf-b437d378d6f3"],
Cell[277718, 5510, 281, 4, 30, "ItemNumbered", "ExpressionUUID" -> \
"2478a90f-a26d-47ca-b9b5-8270e11261d9"],
Cell[278002, 5516, 922, 24, 32, "ItemNumbered", "ExpressionUUID" -> \
"b9846e75-34d7-4e31-be24-e9bc23e27f68"],
Cell[278927, 5542, 1252, 39, 41, "ItemNumbered", "ExpressionUUID" -> \
"7b271806-f2b9-4fae-917c-c90a3d7a40cb"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

